# Laravel 11 Medical Website with Admin Panel

## Project Overview

This is a complete Laravel 11 medical website with a comprehensive admin panel for content management. The project includes:

- **Frontend Website**: Medical billing company website with dynamic content
- **Admin Panel**: Secure admin interface for managing all website content
- **SEO Optimized**: Meta tags, Open Graph, and SEO best practices implemented

## Admin Panel Features

### 1. Authentication System
- Secure admin login/logout
- Password protection
- Session management

### 2. Dashboard
- Overview of website statistics
- Quick access to all modules

### 3. Content Management Modules

#### Home Page Management
- 5 input fields for home content
- 1 textarea for descriptions
- 1 image upload
- Full CRUD operations

#### About Us Management
- 3 input fields (title, subtitle, mission statement)
- 1 textarea for description
- 1 image upload
- Full CRUD operations

#### Services Management
- 1 input field for title
- 2 image uploads
- 1 textarea for description
- Full CRUD operations

#### Specialties Management
- 1 input field for title
- 1 image upload
- 1 textarea for description
- Full CRUD operations

#### FAQs Management
- Question and answer fields
- Sort order functionality
- Full CRUD operations

#### Settings Management
- Site name, email, phone, address
- Logo and favicon upload
- Header, footer, and hero content
- Social media links (Facebook, Instagram, TikTok, LinkedIn, YouTube)
- Map embed code
- SEO meta description and keywords
- Full CRUD operations

#### Contact Form Management
- View contact form submissions
- Mark as read/unread
- Delete messages
- Email integration for replies

#### Admin Users Management
- Add/edit/delete admin users
- Password management
- User roles and permissions
- Full CRUD operations

## Installation Instructions

### 1. Prerequisites
- PHP 8.1 or higher
- Composer
- MySQL/MariaDB
- Web server (Apache/Nginx)

### 2. Setup Steps

1. **Extract the project files**
   ```bash
   unzip medical.zip
   cd medical
   ```

2. **Install dependencies**
   ```bash
   composer install
   ```

3. **Environment configuration**
   ```bash
   cp .env.example .env
   ```
   
   Update the `.env` file with your database credentials:
   ```
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=your_database_name
   DB_USERNAME=your_username
   DB_PASSWORD=your_password
   ```

4. **Generate application key**
   ```bash
   php artisan key:generate
   ```

5. **Create storage directories**
   ```bash
   mkdir -p storage/app/public/home
   mkdir -p storage/app/public/about
   mkdir -p storage/app/public/services
   mkdir -p storage/app/public/specialties
   mkdir -p storage/app/public/settings
   ```

6. **Create symbolic link for storage**
   ```bash
   php artisan storage:link
   ```

7. **Run database migrations**
   ```bash
   php artisan migrate
   ```

8. **Seed admin user**
   ```bash
   php artisan db:seed --class=AdminUserSeeder
   ```

9. **Set proper permissions**
   ```bash
   chmod -R 775 storage
   chmod -R 775 bootstrap/cache
   ```

### 3. Default Admin Credentials

- **Email**: admin@ayzmedflow.com
- **Password**: password123

**Important**: Change these credentials immediately after first login!

## Admin Panel Access

Access the admin panel at: `your-domain.com/admin`

### Admin Panel URLs:
- Login: `/admin/login`
- Dashboard: `/admin`
- Home Management: `/admin/home`
- About Management: `/admin/about`
- Services Management: `/admin/services`
- Specialties Management: `/admin/specialties`
- FAQs Management: `/admin/faqs`
- Settings Management: `/admin/settings`
- Contact Messages: `/admin/contacts`
- Admin Users: `/admin/admin-users`

## Frontend Features

### SEO Optimization
- Dynamic meta tags from settings
- Open Graph tags for social media
- Twitter Card support
- Structured data markup
- SEO-friendly URLs

### Dynamic Content
- All content is fetched from the database
- Settings control site-wide information
- Contact form submissions are stored in database
- Responsive design for all devices

## File Structure

```
medical/
├── app/
│   ├── Http/Controllers/
│   │   ├── AdminAuthController.php
│   │   ├── AdminDashboardController.php
│   │   ├── AdminHomeController.php
│   │   ├── AdminAboutController.php
│   │   ├── AdminServiceController.php
│   │   ├── AdminSpecialtyController.php
│   │   ├── AdminFaqController.php
│   │   ├── AdminSettingController.php
│   │   ├── AdminContactController.php
│   │   ├── AdminUserController.php
│   │   └── FrontController.php
│   ├── Models/
│   │   ├── AdminUser.php
│   │   ├── HomeContent.php
│   │   ├── AboutContent.php
│   │   ├── Service.php
│   │   ├── Specialty.php
│   │   ├── Faq.php
│   │   ├── Setting.php
│   │   └── Contact.php
│   └── Http/Middleware/
│       └── AdminAuth.php
├── database/migrations/
├── resources/views/
│   ├── admin/
│   │   ├── layouts/
│   │   ├── auth/
│   │   ├── home/
│   │   ├── about/
│   │   ├── services/
│   │   ├── specialties/
│   │   ├── faqs/
│   │   ├── settings/
│   │   ├── contacts/
│   │   └── admin-users/
│   └── [frontend views]
├── routes/
│   ├── web.php
│   └── admin.php
└── storage/app/public/
    ├── home/
    ├── about/
    ├── services/
    ├── specialties/
    └── settings/
```

## Security Features

- Admin authentication middleware
- CSRF protection on all forms
- File upload validation
- SQL injection prevention
- XSS protection
- Secure password hashing

## Troubleshooting

### Common Issues

1. **Storage permission errors**
   ```bash
   sudo chown -R www-data:www-data storage
   sudo chmod -R 775 storage
   ```

2. **Database connection errors**
   - Check `.env` database credentials
   - Ensure database exists
   - Verify MySQL/MariaDB is running

3. **Image upload issues**
   - Check storage directory permissions
   - Verify symbolic link exists: `php artisan storage:link`
   - Check file size limits in php.ini

4. **Admin login issues**
   - Run seeder: `php artisan db:seed --class=AdminUserSeeder`
   - Clear cache: `php artisan cache:clear`

## Support

For technical support or questions about this implementation, please refer to the Laravel documentation or contact the development team.

## Version Information

- Laravel: 11.x
- PHP: 8.1+
- Bootstrap: 5.x
- Font Awesome: 5.15.4

---

**Note**: This admin panel provides complete content management for the medical website. All frontend content can be managed through the admin interface, and the system is designed to be SEO-friendly and secure.

