<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\AboutPage;
use Illuminate\Http\Request;

class AboutPageController extends Controller
{
    public function index()
    {
        $aboutPages = AboutPage::all();
        return view('admin.about.index', compact('aboutPages'));
    }

    public function create()
    {
        return view('admin.about.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'content' => 'required|string',
            'main_image' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:4048',
            'gallery_image_1' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:4048',
            'gallery_image_2' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:4048',
            'gallery_image_3' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:4048',
            'years_experience' => 'required|integer|min:0',
            'expert_instructors' => 'required|integer|min:0',
            'students_worldwide' => 'required|integer|min:0',
            'mission' => 'required|string',
            'vision' => 'required|string',
            'values' => 'required|string',
            'why_choose_us' => 'required|string',
            'achievements_list' => 'required|array',
            'meta_title' => 'nullable|string|max:160',
            'meta_description' => 'nullable|string|max:360',
            'meta_keywords' => 'nullable|string|max:355',
        ]);

        // Handle image uploads to public/about directory
        $imageFields = ['main_image', 'gallery_image_1', 'gallery_image_2', 'gallery_image_3'];

        foreach ($imageFields as $field) {
            if ($request->hasFile($field)) {
                $file = $request->file($field);
                $fileName = time() . '_' . $file->getClientOriginalName();
                $file->move(public_path('about'), $fileName);
                $validated[$field] = 'about/' . $fileName; // path for displaying via asset()
            }
        }

        AboutPage::create($validated);

        return redirect()->route('admin.about.index')
            ->with('success', 'About page created successfully.');
    }

    public function show(AboutPage $about)
    {
        return view('admin.about.show', compact('about'));
    }

    public function edit(AboutPage $about)
    {
        return view('admin.about.edit', compact('about'));
    }

    public function update(Request $request, AboutPage $about)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'content' => 'required|string',
            'main_image' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:4048',
            'gallery_image_1' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:4048',
            'gallery_image_2' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:4048',
            'gallery_image_3' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:4048',
            'years_experience' => 'required|integer|min:0',
            'expert_instructors' => 'required|integer|min:0',
            'students_worldwide' => 'required|integer|min:0',
            'mission' => 'required|string',
            'vision' => 'required|string',
            'values' => 'required|string',
            'why_choose_us' => 'required|string',
            'achievements_list' => 'required|array',
            'meta_title' => 'nullable|string|max:160',
            'meta_description' => 'nullable|string|max:360',
            'meta_keywords' => 'nullable|string|max:355',
        ]);

        $imageFields = ['main_image', 'gallery_image_1', 'gallery_image_2', 'gallery_image_3'];

        foreach ($imageFields as $field) {
            if ($request->hasFile($field)) {
                // Delete old image if exists
                if ($about->$field && file_exists(public_path($about->$field))) {
                    unlink(public_path($about->$field));
                }

                $file = $request->file($field);
                $fileName = time() . '_' . $file->getClientOriginalName();
                $file->move(public_path('about'), $fileName);
                $validated[$field] = 'about/' . $fileName;
            } else {
                $validated[$field] = $about->$field;
            }
        }

        $about->update($validated);

        return redirect()->route('admin.about.index')
            ->with('success', 'About page updated successfully.');
    }

    public function destroy(AboutPage $about)
    {
        $imageFields = ['main_image', 'gallery_image_1', 'gallery_image_2', 'gallery_image_3'];

        foreach ($imageFields as $field) {
            if ($about->$field && file_exists(public_path($about->$field))) {
                unlink(public_path($about->$field));
            }
        }

        $about->delete();

        return redirect()->route('admin.about.index')
            ->with('success', 'About page deleted successfully.');
    }
}
