<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AboutContent;
use Illuminate\Support\Facades\Storage;

class AdminAboutController extends Controller
{
    public function index()
    {
        $aboutContents = AboutContent::latest()->paginate(10);
                    $contentExists = AboutContent::exists(); // Replace YourModel with your actual model
        return view('admin.about.index', compact('aboutContents', 'contentExists'));
    }

    public function create()
    {
        return view('admin.about.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'required|string|max:255',
            'mission_statement' => 'required|string|max:255',
            'description' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'is_active' => 'boolean'
        ]);

        $data = $request->all();
        $data['is_active'] = $request->has('is_active');

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->storeAs('public/about', $imageName);
            $data['image'] = $imageName;
        }

        AboutContent::create($data);

        return redirect()->route('admin.about.index')->with('success', 'About content created successfully.');
    }

    public function show(AboutContent $about)
    {
        return view('admin.about.show', compact('about'));
    }

    public function edit(AboutContent $about)
    {
        return view('admin.about.edit', compact('about'));
    }

    public function update(Request $request, AboutContent $about)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'required|string|max:255',
            'mission_statement' => 'required|string|max:255',
            'description' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'is_active' => 'boolean'
        ]);

        $data = $request->all();
        $data['is_active'] = $request->has('is_active');

        if ($request->hasFile('image')) {
            // Delete old image
            if ($about->image) {
                Storage::delete('public/about/' . $about->image);
            }

            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->storeAs('public/about', $imageName);
            $data['image'] = $imageName;
        }

        $about->update($data);

        return redirect()->route('admin.about.index')->with('success', 'About content updated successfully.');
    }

    public function destroy(AboutContent $about)
    {
        // Delete image file
        if ($about->image) {
            Storage::delete('public/about/' . $about->image);
        }

        $about->delete();

        return redirect()->route('admin.about.index')->with('success', 'About content deleted successfully.');
    }
}

