<?php
// app/Http/Controllers/AdminDashboardController.php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AdminUser;
use App\Models\Faq;
use App\Models\Service;
use App\Models\Specialty;
use App\Models\Contact;
use App\Models\Course;
use App\Models\Teacher;
use App\Models\Enrollment;

class AdminDashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'title' => Course::count(),
            'total_teachers' => Teacher::count(),
            'total_enrollments' => Enrollment::count(),
            'total_pending_enrollments' => Enrollment::where('status', 'pending')->count(),
            'total_admins' => AdminUser::count(),
            'total_services' => Service::count(),
            'total_specialties' => Specialty::count(),
            'total_faqs' => Faq::count(),
            'total_contacts' => Contact::count(),
            'revenue' => $this->calculateRevenue(),
        ];

        // Recent enrollments for dashboard
        $recentEnrollments = Enrollment::with('course')
            ->latest()
            ->take(5)
            ->get();

        // Course statistics
        $courseStats = [
            'active_courses' => Course::where('is_active', true)->count(),
            'featured_courses' => Course::where('is_featured', true)->count(),
            'free_courses' => Course::where('price_type', 'free')->count(),
            'paid_courses' => Course::where('price_type', 'paid')->count(),
        ];

        return view('admin.dashboard', compact('stats', 'recentEnrollments', 'courseStats'));
    }

    private function calculateRevenue()
    {
        // Calculate total revenue from paid courses enrollments
        return Enrollment::whereHas('course', function($query) {
            $query->where('price_type', 'paid');
        })->count() * 49.99; // Assuming each paid course is $49.99
    }
}