<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Service;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str; // ✅ Add this line

class AdminServiceController extends Controller
{
    public function index()
    {
        $services = Service::latest()->paginate(10);
        return view('admin.services.index', compact('services'));
    }

    public function create()
    {
        return view('admin.services.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'short' => 'required|string',
            'description' => 'required|string',
            'image_1' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'is_active' => 'boolean'
        ]);

        $data = $request->all();
        $data['is_active'] = $request->has('is_active');
            $data['slug'] = Str::slug($request->title); // 🔑 generate slug


        if ($request->hasFile('image_1')) {
            $image1 = $request->file('image_1');
            $image1Name = time() . '_1_' . $image1->getClientOriginalName();
            $image1->storeAs('public/services', $image1Name);
            $data['image_1'] = $image1Name;
        }

     

        Service::create($data);

        return redirect()->route('admin.services.index')->with('success', 'Service created successfully.');
    }

    public function show(Service $service)
    {
        return view('admin.services.show', compact('service'));
    }

    public function edit(Service $service)
    {
        return view('admin.services.edit', compact('service'));
    }

    public function update(Request $request, Service $service)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'short' => 'required|string',
            'description' => 'required|string',
            'image_1' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'is_active' => 'boolean'
        ]);

        $data = $request->all();
        $data['is_active'] = $request->has('is_active');
            $data['slug'] = Str::slug($request->title); 

        if ($request->hasFile('image_1')) {
            // Delete old image
            if ($service->image_1) {
                Storage::delete('public/services/' . $service->image_1);
            }

            $image1 = $request->file('image_1');
            $image1Name = time() . '_1_' . $image1->getClientOriginalName();
            $image1->storeAs('public/services', $image1Name);
            $data['image_1'] = $image1Name;
        }

     

        $service->update($data);

        return redirect()->route('admin.services.index')->with('success', 'Service updated successfully.');
    }

    public function destroy(Service $service)
    {
        // Delete image files
        if ($service->image_1) {
            Storage::delete('public/services/' . $service->image_1);
        }
   

        $service->delete();

        return redirect()->route('admin.services.index')->with('success', 'Service deleted successfully.');
    }
}

