<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AdminSettingController extends Controller
{
    public function index()
    {
        $setting = Setting::first();
        if (!$setting) {
            $setting = Setting::create([]);
        }
        return view('admin.settings.index', compact('setting'));
    }

    public function create()
    {
        return redirect()->route('admin.settings.index');
    }

    public function store(Request $request)
    {
        return redirect()->route('admin.settings.index');
    }

    public function show(Setting $setting)
    {
        return redirect()->route('admin.settings.index');
    }

    public function edit(Setting $setting)
    {
        return redirect()->route('admin.settings.index');
    }

public function update(Request $request)
{
    $request->validate([
        'site_name' => 'nullable|string|max:255',
        'site_email' => 'nullable|email|max:255',
        'site_phone' => 'nullable|string|max:255',
        'site_address' => 'nullable|string',
        'header_content' => 'nullable|string',
        'footer_content' => 'nullable|string',
        'footer_short_text' => 'nullable|string',
        'hero_content' => 'nullable|string',
        'facebook_url' => 'nullable|url|max:255',
        'instagram_url' => 'nullable|url|max:255',
        'tiktok_url' => 'nullable|url|max:255',
        'linkedin_url' => 'nullable|url|max:255',
        'youtube_url' => 'nullable|url|max:255',
        'map_embed_code' => 'nullable|string',
        'meta_description' => 'nullable|string',
        'meta_keywords' => 'nullable|string',
        'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        'favicon' => 'nullable|image|mimes:jpeg,png,jpg,gif,ico|max:1024',
    ]);

    $setting = Setting::first() ?? new Setting();
    $data = $request->except(['logo', 'favicon']);

    $uploadPath = public_path('uploads/nadeem'); // <-- CHANGE HERE
    if (!file_exists($uploadPath)) {
        mkdir($uploadPath, 0755, true);
    }

    // Handle logo
    if ($request->hasFile('logo')) {
        if ($setting->logo && file_exists(public_path($setting->logo))) {
            unlink(public_path($setting->logo));
        }
        $logoName = time() . '_' . $request->file('logo')->getClientOriginalName();
        $request->file('logo')->move($uploadPath, $logoName);
        $data['logo'] = 'uploads/nadeem/' . $logoName; // <-- CHANGE HERE
    }

    // Handle favicon
    if ($request->hasFile('favicon')) {
        if ($setting->favicon && file_exists(public_path($setting->favicon))) {
            unlink(public_path($setting->favicon));
        }
        $faviconName = time() . '_' . $request->file('favicon')->getClientOriginalName();
        $request->file('favicon')->move($uploadPath, $faviconName);
        $data['favicon'] = 'uploads/nadeem/' . $faviconName; // <-- CHANGE HERE
    }

    $setting->fill($data);
    $setting->save();

    return redirect()->route('admin.settings.index')
        ->with('success', 'Settings updated successfully!');
}


    public function destroy(Setting $setting)
    {
        return redirect()->route('admin.settings.index');
    }
}

