<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Appointment;

class AppointmentController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'type' => 'required|string',
            'practice_name' => 'required|string|max:255',
            'name' => 'required|string|max:255',
            'monthly_collections' => 'nullable|string|max:255',
            'email' => 'required|email',
            'phone' => 'required|string|max:20',
            'appointment_date' => 'required|date',
            'appointment_time' => 'required',
            'message' => 'nullable|string',
        ]);

        Appointment::create($validated);

        return back()->with('success', 'Appointment booked successfully!');
    }
  public function index()
    {
        $appointments = Appointment::latest()->paginate(10);
        return view('admin.appointments.index', compact('appointments'));
    }
  public function destroy($id)
    {
        Appointment::destroy($id);
        return back()->with('success', 'Appointment deleted successfully!');
    }

    public function show($id)
{
    $appointment = Appointment::findOrFail($id);
    return view('admin.appointments.show', compact('appointment'));
}
}

