<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\BlogComment;
use App\Models\BlogPost;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class BlogCommentController extends Controller
{
public function store(Request $request, $post_id)
{
    $request->validate([
        'name'    => 'required|string|max:255',
        'email'   => 'required|email',
        'comment' => 'required|string|max:500',
    ]);

    $comment = new \App\Models\BlogComment;
    $comment->post_id  = $post_id;
    $comment->name     = $request->name;
    $comment->email    = $request->email;
    $comment->comment  = $request->comment;
    $comment->parent_id= $request->parent_id ?? null;
    $comment->save();

    // ALWAYS return JSON regardless of ajax check
          $message = $request->parent_id ? 'Reply posted successfully!' : 'Comment posted successfully!';
                  return redirect()->back()->with('success', $message);

}
}
