<?php

namespace App\Mail;

use App\Models\Enrollment;
use App\Models\Setting;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AdminEnrollmentNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $enrollment;
    public $setting;

    public function __construct(Enrollment $enrollment, Setting $setting)
    {
        $this->enrollment = $enrollment;
        $this->setting = $setting;
    }

 public function build()
{
    $email = $this->subject('📚 New Course Enrollment - ' . $this->enrollment->enrollment_code)
                  ->view('emails.admin.enrollment-notification')
                  ->with([
                      'enrollment' => $this->enrollment,
                      'setting' => $this->setting,
                  ]);

    // ✅ Embed logo if exists
    if ($this->setting->logo && file_exists(public_path($this->setting->logo))) {
        $email->attach(public_path($this->setting->logo), [
            'as' => 'logo.png',
            'mime' => 'image/png',
        ]);
    }

    return $email;
}

}