<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AboutPage extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'content',
        'main_image',
        'gallery_image_1',
        'gallery_image_2',
        'gallery_image_3',
        'years_experience',
        'expert_instructors',
        'students_worldwide',
        'mission',
        'vision',
        'values',
        'why_choose_us',
        'achievements_list',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'is_active'
    ];

    protected $casts = [
        'achievements_list' => 'array',
        'is_active' => 'boolean'
    ];
}