<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BlogComment extends Model {
    protected $fillable = ['post_id', 'parent_id', 'name', 'email', 'comment'];

    public function replies() {
        return $this->hasMany(BlogComment::class, 'parent_id')->orderBy('created_at', 'desc');;
    }
}
