<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BlogPost extends Model
{
    protected $fillable = [
        'title',
        'slug', 
        'short_description',
        'content',
        'tags',
        'category_id',
        'image',
        'author',
        'meta_title',
        'meta_description', 
        'meta_keywords',
        'og_title',
        'og_description',
        'og_image',
        'canonical_url',
        'robots'
    ];

    public function category()
    {
        return $this->belongsTo(BlogCategory::class);
    }

    public function comments()
    {
        return $this->hasMany(BlogComment::class, 'post_id')
                    ->whereNull('parent_id')
                    ->orderBy('created_at', 'desc');
    }
}
