<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Enrollment extends Model
{
    use HasFactory;

    protected $fillable = [
        'course_id',
        'first_name',
        'last_name',
        'email',
        'phone',
        'education_level',
        'experience_level',
        'motivation',
        'preferred_schedule',
        'newsletter_optin',
        'status',
        'enrollment_code'
    ];

    public function course()
    {
        return $this->belongsTo(Course::class);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($enrollment) {
            $enrollment->enrollment_code = 'ENR' . date('Ymd') . strtoupper(uniqid());
        });
    }
}