<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'slug',
        'short',
        'image_1',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function getImage1UrlAttribute()
    {
        if ($this->image_1) {
            return asset('storage/services/' . $this->image_1);
        }
        return null;
    }

    public function getImage2UrlAttribute()
    {
        if ($this->image_2) {
            return asset('storage/services/' . $this->image_2);
        }
        return null;
    }
}

