<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
    
         'site_name',
        'site_email',
        'site_phone',
        'site_address',
        'logo',
        'favicon',
        'header_content',
        'footer_content',
        'footer_short_text',
        'hero_content',
        'facebook_url',
        'instagram_url',
        'tiktok_url',
        'linkedin_url',
        'youtube_url',
        'map_embed_code',
        'meta_description',
        'meta_keywords',
    ];

    public function getLogoUrlAttribute()
    {
        if ($this->logo) {
            return asset('storage/settings/' . $this->logo);
        }
        return null;
    }

    public function getFaviconUrlAttribute()
    {
        if ($this->favicon) {
            return asset('storage/settings/' . $this->favicon);
        }
        return null;
    }

    public static function getSettings()
    {
        return self::first() ?? new self();
    }
}

