<?php
// app/Models/Teacher.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Teacher extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'email',
        'phone',
        'bio',
        'qualifications',
        'specialization',
        'experience_years',
        'profile_image',
        'facebook_url',
        'twitter_url',
        'linkedin_url',
        'website_url',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'is_active',
        'is_featured'
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($teacher) {
            if (empty($teacher->slug)) {
                $teacher->slug = Str::slug($teacher->name);
            }
        });

        static::updating(function ($teacher) {
            if ($teacher->isDirty('name') && empty($teacher->slug)) {
                $teacher->slug = Str::slug($teacher->name);
            }
        });
    }

    public function courses()
    {
        return $this->hasMany(Course::class, 'teacher_id');
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function getSocialLinksAttribute()
    {
        return [
            'facebook' => $this->facebook_url,
            'twitter' => $this->twitter_url,
            'linkedin' => $this->linkedin_url,
            'website' => $this->website_url,
        ];
    }
}