<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
public function boot(): void
{
    $this->routes(function () {
        // Admin routes — clearly separated
        Route::middleware('web')
            ->prefix('admin')
            ->name('admin.') // Optional, for route name prefixing
            ->group(base_path('routes/admin.php'));

        // Web routes — frontend only
        Route::middleware('web')
            ->group(base_path('routes/web.php'));
    });
}

}
