<?php
// database/migrations/xxxx_xx_xx_xxxxxx_create_courses_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('description');
          $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->foreignId('category_id')->constrained()->onDelete('cascade');
            $table->foreignId('teacher_id')->constrained()->onDelete('cascade');
            $table->enum('level', ['beginner', 'intermediate', 'advanced']);
            $table->integer('duration_value');
            $table->enum('duration', ['hours', 'days', 'weeks', 'months']);            
            $table->enum('price_type', ['free', 'paid']);
            $table->decimal('price', 8, 2)->nullable();
            $table->enum('label', ['new', 'popular', 'featured'])->nullable();
            $table->boolean('has_certificate')->default(false);
            $table->string('image')->nullable();
            $table->decimal('ratings', 3, 2)->default(0);
            $table->integer('total_students')->default(0);
            $table->text('requirements')->nullable();
            $table->text('what_you_learn')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->timestamps();

        });
    }



    public function down()
    {
        Schema::dropIfExists('courses');
    }
};