<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('enrollments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('course_id')->constrained()->onDelete('cascade');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email');
            $table->string('phone');
            $table->string('education_level')->nullable();
            $table->string('experience_level')->nullable();
            $table->text('motivation')->nullable();
            $table->string('preferred_schedule')->default('flexible');
            $table->boolean('newsletter_optin')->default(false);
            $table->string('status')->default('pending');
            $table->string('enrollment_code')->unique();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('enrollments');
    }
};