<?php
// database/seeders/CourseSeeder.php

namespace Database\Seeders;

use App\Models\Course;
use Illuminate\Database\Seeder;

class CourseSeeder extends Seeder
{
    public function run()
    {
        $courses = [
            [
                'title' => 'Laravel 11 Complete Course',
                'description' => 'Learn Laravel 11 from scratch with this comprehensive course covering all the latest features and best practices.',
                'category' => 'Web Development',
                'level' => 'intermediate',
                'duration' => 45,
                'price_type' => 'paid',
                'price' => 99.99,
                'label' => 'popular',
                'has_certificate' => true,
                'ratings' => 4.5,
                'teacher_name' => 'John Doe',
                'total_students' => 1250,
            ],
            [
                'title' => 'JavaScript Fundamentals',
                'description' => 'Master the basics of JavaScript programming language with hands-on examples and projects.',
                'category' => 'Programming',
                'level' => 'beginner',
                'duration' => 30,
                'price_type' => 'free',
                'price' => 0,
                'label' => 'new',
                'has_certificate' => true,
                'ratings' => 4.2,
                'teacher_name' => 'Jane Smith',
                'total_students' => 3500,
            ],
            // Add more sample courses...
        ];

        foreach ($courses as $course) {
            Course::create($course);
        }
    }
}