@extends('apps')
<!-- SEO Meta Tags -->
@section('title', $about->meta_title ?: $about->title)
@section('meta_description', $about->meta_description)
@section('meta_keywords', $about->meta_keywords)
@section('content')

<main class="main">

    <!-- Page Title -->
    <div class="page-title light-background">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">{{ $about->title }}</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="{{ url('/') }}">Home</a></li>
            <li class="current">About</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- About Section -->
    <section id="about" class="about section">

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row align-items-center">
          <div class="col-lg-6" data-aos="fade-up" data-aos-delay="200">
            <img src="{{ asset($about->main_image) }}" alt="About Us" class="img-fluid rounded-4">
          </div>
          <div class="col-lg-6" data-aos="fade-up" data-aos-delay="300">
            <div class="about-content">
              <span class="subtitle">About Us</span>
              <h2>{{ $about->title }}</h2>
              <p>{{ $about->content }}</p>
              <div class="stats-row">
                <div class="stats-item">
                  <span class="count">{{ $about->years_experience }}</span>
                  <p>Years of Experience</p>
                </div>
                <div class="stats-item">
                  <span class="count">{{ $about->expert_instructors }}+</span>
                  <p>Expert Instructors</p>
                </div>
                <div class="stats-item">
                  <span class="count">{{ $about->students_worldwide }}+</span>
                  <p>Students Worldwide</p>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="row mt-5 pt-4">
          <div class="col-lg-4" data-aos="fade-up" data-aos-delay="200">
            <div class="mission-card">
              <div class="icon-box">
                <i class="bi bi-bullseye"></i>
              </div>
              <h3>Our Mission</h3>
              <p>{{ $about->mission }}</p>
            </div>
          </div>
          <div class="col-lg-4" data-aos="fade-up" data-aos-delay="300">
            <div class="mission-card">
              <div class="icon-box">
                <i class="bi bi-eye"></i>
              </div>
              <h3>Our Vision</h3>
              <p>{{ $about->vision }}</p>
            </div>
          </div>
          <div class="col-lg-4" data-aos="fade-up" data-aos-delay="400">
            <div class="mission-card">
              <div class="icon-box">
                <i class="bi bi-award"></i>
              </div>
              <h3>Our Values</h3>
              <p>{{ $about->values }}</p>
            </div>
          </div>
        </div>

        <div class="row mt-5 pt-3 align-items-center">
          <div class="col-lg-6 order-lg-2" data-aos="fade-up" data-aos-delay="300">
            <div class="achievements">
              <span class="subtitle">Why Choose Us</span>
              <h2>Transforming Education for a Better Tomorrow</h2>
              <p>{{ $about->why_choose_us }}</p>
              <ul class="achievements-list">
                @foreach($about->achievements_list as $achievement)
                <li><i class="bi bi-check-circle-fill"></i> {{ $achievement }}</li>
                @endforeach
              </ul>
              <a href="#" class="btn-explore">Discover More <i class="bi bi-arrow-right"></i></a>
            </div>
          </div>
          <div class="col-lg-6 order-lg-1" data-aos="fade-up" data-aos-delay="200">
            <div class="about-gallery">
              <div class="row g-3">
                <div class="col-6">
                  <img src="{{ asset($about->gallery_image_1) }}" alt="Campus Life" class="img-fluid rounded-3">
                </div>
                <div class="col-6">
                  <img src="{{ asset($about->gallery_image_2) }}" alt="Student Achievement" class="img-fluid rounded-3">
                </div>
                <div class="col-12 mt-3">
                  <img src="{{ asset($about->gallery_image_3) }}" alt="Our Campus" class="img-fluid rounded-3">
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>

    </section><!-- /About Section -->

</main>
@endsection
