@extends('admin.layouts.app')

@section('title', 'View About Page')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">About Page Details</h3>
                    <div>
                        <a href="{{ route('admin.about.edit', $about->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.about.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Basic Information</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="200">Title</th>
                                            <td>{{ $about->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>Content</th>
                                            <td>{{ $about->content }}</td>
                                        </tr>
                                        <tr>
                                            <th>Mission</th>
                                            <td>{{ $about->mission }}</td>
                                        </tr>
                                        <tr>
                                            <th>Vision</th>
                                            <td>{{ $about->vision }}</td>
                                        </tr>
                                        <tr>
                                            <th>Values</th>
                                            <td>{{ $about->values }}</td>
                                        </tr>
                                        <tr>
                                            <th>Why Choose Us</th>
                                            <td>{{ $about->why_choose_us }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="card mt-3">
                                <div class="card-header">
                                    <h4>Achievements List</h4>
                                </div>
                                <div class="card-body">
                                    <ul class="list-group">
                                        @foreach($about->achievements_list as $achievement)
                                        <li class="list-group-item">
                                            <i class="fas fa-check text-success mr-2"></i> {{ $achievement }}
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Statistics</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Years Experience</th>
                                            <td>{{ $about->years_experience }}</td>
                                        </tr>
                                        <tr>
                                            <th>Expert Instructors</th>
                                            <td>{{ $about->expert_instructors }}</td>
                                        </tr>
                                        <tr>
                                            <th>Students Worldwide</th>
                                            <td>{{ $about->students_worldwide }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="card mt-3">
                                <div class="card-header">
                                    <h4>Images</h4>
                                </div>
                                <div class="card-body">
                                    @if($about->main_image)
                                    <div class="mb-3">
                                        <strong>Main Image:</strong><br>
                                        <img src="{{ asset( $about->main_image) }}" alt="Main Image" class="img-thumbnail" width="200">
                                    </div>
                                    @endif

                                    @if($about->gallery_image_1)
                                    <div class="mb-3">
                                        <strong>Gallery Image 1:</strong><br>
                                        <img src="{{ asset( $about->gallery_image_1) }}" alt="Gallery Image 1" class="img-thumbnail" width="200">
                                    </div>
                                    @endif

                                    @if($about->gallery_image_2)
                                    <div class="mb-3">
                                        <strong>Gallery Image 2:</strong><br>
                                        <img src="{{ asset( $about->gallery_image_2) }}" alt="Gallery Image 2" class="img-thumbnail" width="200">
                                    </div>
                                    @endif

                                    @if($about->gallery_image_3)
                                    <div class="mb-3">
                                        <strong>Gallery Image 3:</strong><br>
                                        <img src="{{ asset( $about->gallery_image_3) }}" alt="Gallery Image 3" class="img-thumbnail" width="200">
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <div class="card mt-3">
                                <div class="card-header">
                                    <h4>SEO Settings</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Meta Title</th>
                                            <td>{{ $about->meta_title ?? 'Not set' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Meta Description</th>
                                            <td>{{ $about->meta_description ?? 'Not set' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Meta Keywords</th>
                                            <td>{{ $about->meta_keywords ?? 'Not set' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="card mt-3">
                                <div class="card-header">
                                    <h4>Status & Dates</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Status</th>
                                            <td>
                                                <span class="badge {{ $about->is_active ? 'bg-success' : 'bg-danger' }}">
                                                    {{ $about->is_active ? 'Active' : 'Inactive' }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Created At</th>
                                            <td>{{ $about->created_at->format('d M, Y H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Updated At</th>
                                            <td>{{ $about->updated_at->format('d M, Y H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection