@extends('admin.layouts.app')

@section('title', 'Add Admin User')
@section('page-title', 'Add Admin User')

@section('content')
<div class="container-fluid">
  <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
    <h2 class="fw-bold text-dark mb-0">
      <i class="fas fa-plus-circle text-success me-2"></i>Add Admin
    </h2>
    <a href="{{ route('admin.admin-users.index') }}" class="btn btn-outline-secondary rounded-pill">
      <i class="fas fa-arrow-left me-2"></i>Back
    </a>
  </div>

  <div class="card border-0 rounded-4 shadow-sm">
    <div class="card-body p-4">
      <form action="{{ route('admin.admin-users.store') }}" method="POST">
        @csrf

        <div class="mb-3">
          <label class="form-label fw-semibold">Name <span class="text-danger">*</span></label>
          <input type="text" name="name" value="{{ old('name') }}" class="form-control rounded-3" required>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">Email <span class="text-danger">*</span></label>
          <input type="email" name="email" value="{{ old('email') }}" class="form-control rounded-3" required>
        </div>

        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label fw-semibold">Password <span class="text-danger">*</span></label>
            <input type="password" name="password" class="form-control rounded-3" required>
            <div class="form-text">≥ 8 characters</div>
          </div>
          <div class="col-md-6">
            <label class="form-label fw-semibold">Confirm Password <span class="text-danger">*</span></label>
            <input type="password" name="password_confirmation" class="form-control rounded-3" required>
          </div>
        </div>

        <div class="d-flex flex-column flex-sm-row justify-content-between gap-2 mt-4">
          <a href="{{ route('admin.admin-users.index') }}" class="btn btn-outline-secondary rounded-pill">Cancel</a>
          <button type="submit" class="btn btn-success rounded-pill px-4">Create Admin</button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection