@extends('admin.layouts.app')

@section('title', 'View Admin User')
@section('page-title', 'View Admin User')

@section('content')
<div class="container-fluid">
  <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
    <h2 class="fw-bold text-dark mb-0">
      <i class="fas fa-user text-success me-2"></i>{{ $adminUser->name }}
    </h2>
    <div class="d-flex gap-2">
      <a href="{{ route('admin.admin-users.edit', $adminUser) }}" class="btn btn-outline-success rounded-pill">
        <i class="fas fa-edit me-1"></i>Edit
      </a>
      @if($adminUser->id !== auth('admin')->id() && \App\Models\AdminUser::count() > 1)
        <form action="{{ route('admin.admin-users.destroy', $adminUser) }}" method="POST"
              onsubmit="return confirm('Delete this admin?')" class="d-inline">
          @csrf @method('DELETE')
          <button type="submit" class="btn btn-outline-danger rounded-pill">
            <i class="fas fa-trash me-1"></i>Delete
          </button>
        </form>
      @endif
    </div>
  </div>

  <div class="row">
    <div class="col-lg-8">
      <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">
          <table class="table table-borderless mb-0">
            <tr><th width="160" class="text-muted">ID</th><td>{{ $adminUser->id }}</td></tr>
            <tr><th class="text-muted">Name</th><td>{{ $adminUser->name }}</td></tr>
            <tr><th class="text-muted">Email</th><td>{{ $adminUser->email }}</td></tr>
            <tr>
              <th class="text-muted">Status</th>
              <td>
                @if($adminUser->id === auth('admin')->id())
                  <span class="badge rounded-pill bg-info">Current User</span>
                @else
                  <span class="badge rounded-pill bg-success">Active</span>
                @endif
              </td>
            </tr>
    <tr>
  <th class="text-muted">Created</th>
  <td>
    {{ $adminUser->created_at ? $adminUser->created_at->format('M d, Y h:i A') : 'N/A' }}
  </td>
</tr>

<tr>
  <th class="text-muted">Updated</th>
  <td>
    {{ $adminUser->updated_at ? $adminUser->updated_at->format('M d, Y h:i A') : 'N/A' }}
  </td>
</tr>

            <tr><th class="text-muted">Last Login</th>
              <td>
                @if($adminUser->id === auth('admin')->id())
                  <span class="text-success">Currently logged in</span>
                @else
                  <span class="text-muted">Not available</span>
                @endif
              </td>
            </tr>
          </table>
        </div>
      </div>
    </div>

    <div class="col-lg-4">
      <div class="card border-0 rounded-4 shadow-sm text-center">
        <div class="card-body p-4">
          <i class="fas fa-user-shield fa-4x text-primary mb-3"></i>
          <h6 class="fw-semibold">Admin User</h6>
          <p class="text-muted">Full admin-panel access</p>
          @if($adminUser->id === auth('admin')->id())
            <div class="alert alert-info small mb-0">
              <i class="fas fa-info-circle me-1"></i>This is your account
            </div>
          @endif
        </div>
      </div>
    </div>
  </div>

  <div class="text-center mt-4">
    <a href="{{ route('admin.admin-users.index') }}" class="btn btn-outline-secondary rounded-pill px-4">
      <i class="fas fa-arrow-left me-2"></i>Back to List
    </a>
  </div>
</div>
@endsection