@extends('admin.layouts.app')

@section('title', 'Appointments')

@section('content')
<div class="container-fluid py-4">
    <h2 class="fw-bold text-dark mb-4">
        <i class="fas fa-calendar-check me-2 text-primary"></i>Appointments
    </h2>

    @if(session('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Deleted!',
                text: '{{ session("success") }}',
                confirmButtonColor: '#3085d6'
            });
        </script>
    @endif

    <div class="card shadow-sm border-0">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark text-nowrap">
                        <tr class="align-middle text-center">
                            <th>#</th>
                            <th>Type</th>
                            <th>Practice Name</th>
                            <th>Name</th>
                            <th>Monthly Collections</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Date</th>
                            <th>Time</th>
                            <th>Message</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($appointments as $key => $appt)
                            <tr class="text-center">
                                <td>{{ $appointments->firstItem() + $key }}</td>
                                <td>
                                    <span class="badge bg-primary">{{ $appt->type }}</span>
                                </td>
                                <td>{{ $appt->practice_name }}</td>
                                <td>{{ $appt->name }}</td>
                                <td>{{ $appt->monthly_collections }}</td>
                                <td>{{ $appt->email }}</td>
                                <td>{{ $appt->phone }}</td>
                                <td>{{ \Carbon\Carbon::parse($appt->appointment_date)->format('d M Y') }}</td>
                                <td>{{ \Carbon\Carbon::parse($appt->appointment_time)->format('h:i A') }}</td>
                                <td class="text-start">{{ Str::limit($appt->message, 50) }}</td>
                                <td>
                                    <div class="d-flex justify-content-center gap-1">
                                        <a href="{{ route('admin.appointments.show', $appt) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <form method="POST" action="{{ route('admin.appointments.destroy', $appt->id) }}" class="d-inline delete-form">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger delete-btn">
                                                <i class="fas fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="11" class="text-center text-muted py-4">No appointments found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        @if ($appointments->hasPages())
            <div class="card-footer d-flex justify-content-center py-3">
                {{ $appointments->links('pagination::bootstrap-5') }}
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.querySelectorAll('.delete-form').forEach(form => {
        form.addEventListener('submit', function (e) {
            e.preventDefault();
            Swal.fire({
                title: 'Are you sure?',
                text: "This appointment will be permanently deleted!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>
@endpush
