<div class="container">
    <h1 class="my-4">{{ isset($post) ? 'Update Blog' : 'Add New Blog' }}</h1>

    {{-- Error Messages --}}
    @if($errors->any())
        <div class="alert alert-danger">
            <h5>Please fix the following errors:</h5>
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <form id="blogForm" action="{{ isset($post) ? route('admin.posts.update', $post->id) : route('admin.posts.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        @if(isset($post))
            @method('PUT')
        @endif

        {{-- Form fields same as before --}}
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="title" class="form-label">Blog Title</label>
                    <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title', $post->title ?? '') }}" required>
                    @error('title')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="col-md-6">
                <div class="mb-3">
                    <label for="category" class="form-label">Category</label>
                    <select class="form-select @error('category_id') is-invalid @enderror" id="category" name="category_id" required>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ (old('category_id', $post->category_id ?? '') == $category->id) ? 'selected' : '' }}>{{ $category->name }}</option>
                        @endforeach
                    </select>
                    @error('category_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="mb-3">
            <label for="slug" class="form-label">Slug (unique)</label>
            <input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug" name="slug" value="{{ old('slug', $post->slug ?? '') }}" required>
            @error('slug')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="short_description" class="form-label">Short Description</label>
            <textarea class="form-control @error('short_description') is-invalid @enderror" id="short_description" name="short_description" rows="3" required>{{ old('short_description', $post->short_description ?? '') }}</textarea>
            @error('short_description')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="image" class="form-label">Blog Image</label>
            <input type="file" class="form-control @error('image') is-invalid @enderror" id="image" name="image" accept=".jpg,.jpeg,.png,.webp">
            @error('image')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
            @if(isset($post) && $post->image)
                <br>
                <img src="{{ asset('blogs/'.$post->image) }}" width="150">
            @endif
        </div>

        <div class="mb-3">
            <label for="content" class="form-label">Content</label>
            <textarea class="form-control @error('content') is-invalid @enderror" id="editor" name="content" rows="5">{{ old('content', $post->content ?? '') }}</textarea>
            @error('content')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="tags" class="form-label">Tags (comma separated)</label>
            <input type="text" class="form-control @error('tags') is-invalid @enderror" id="tags" name="tags" value="{{ old('tags', $post->tags ?? '') }}">
            @error('tags')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

{{-- SEO Section --}}
<div class="card mt-4">
    <div class="card-header">
        <h5>SEO Settings</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="meta_title">Meta Title</label>
                    <input type="text" class="form-control" id="meta_title" name="meta_title" 
                           value="{{ old('meta_title', $post->meta_title ?? '') }}" 
                           placeholder="Meta Title (max 60 characters)">
                    <small class="text-muted">Recommended: 50-60 characters</small>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="meta_keywords">Meta Keywords</label>
                    <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" 
                           value="{{ old('meta_keywords', $post->meta_keywords ?? '') }}" 
                           placeholder="Keyword1, Keyword2, Keyword3">
                    <small class="text-muted">Separate with commas</small>
                </div>
            </div>
        </div>
        
        <div class="form-group">
            <label for="meta_description">Meta Description</label>
            <textarea class="form-control" id="meta_description" name="meta_description" 
                      rows="3" placeholder="Meta Description (max 160 characters)">{{ old('meta_description', $post->meta_description ?? '') }}</textarea>
            <small class="text-muted">Recommended: 150-160 characters</small>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="og_title">OG Title</label>
                    <input type="text" class="form-control" id="og_title" name="og_title" 
                           value="{{ old('og_title', $post->og_title ?? '') }}" 
                           placeholder="Open Graph Title">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="robots">Robots Meta</label>
                    <select class="form-control" id="robots" name="robots">
                        <option value="index, follow" {{ ($post->robots ?? '') == 'index, follow' ? 'selected' : '' }}>Index, Follow</option>
                        <option value="noindex, follow" {{ ($post->robots ?? '') == 'noindex, follow' ? 'selected' : '' }}>NoIndex, Follow</option>
                        <option value="index, nofollow" {{ ($post->robots ?? '') == 'index, nofollow' ? 'selected' : '' }}>Index, NoFollow</option>
                        <option value="noindex, nofollow" {{ ($post->robots ?? '') == 'noindex, nofollow' ? 'selected' : '' }}>NoIndex, NoFollow</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group">
            <label for="og_description">OG Description</label>
            <textarea class="form-control" id="og_description" name="og_description" 
                      rows="2" placeholder="Open Graph Description">{{ old('og_description', $post->og_description ?? '') }}</textarea>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="og_image">OG Image</label>
                    <input type="file" class="form-control-file" id="og_image" name="og_image">
                    <small class="text-muted">Recommended: 1200x630 pixels</small>
                    @if(isset($post) && $post->og_image)
                        <div class="mt-2">
                            <img src="{{ asset('blogs/og/' . $post->og_image) }}" alt="OG Image" width="100">
                        </div>
                    @endif
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="canonical_url">Canonical URL</label>
                    <input type="url" class="form-control" id="canonical_url" name="canonical_url" 
                           value="{{ old('canonical_url', $post->canonical_url ?? '') }}" 
                           placeholder="https://example.com/canonical-url">
                </div>
            </div>
        </div>
    </div>
</div>
<br>

          <button type="submit" class="btn btn-primary">{{ isset($post) ? 'Update Blog' : 'Save Blog' }}</button>
        </form>
      </div>






