@extends('admin.layouts.app')
@section('title', 'Add Testimonial')
@section('page-title', 'Add Testimonial')

@section('content')

          <div class="content-wrapper">
            <div class="row">
  
    <div class="container">
        <h2 class="my-4">Manage Blogs</h2>
       
        <a href="{{ route('admin.posts.create') }}" class="btn  btn-success btn-sm mb-2  text-white" style="float: right;"><i class="fa fa-plus"></i> Add New Blog</a>

        <!-- Blogs Table with Pagination -->
        <table  class="table table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Title</th>
                    <th>Category</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($posts as $blog)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $blog->title }}</td>
                        <td>{{ $blog->category->name }}</td>
                        <td>{{ $blog->created_at->format('d/m/Y') }}</td>
                        <td>
                            <a href="{{ route('admin.posts.edit', $blog->id) }}" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i> Update</a>
                            <form action="{{ route('admin.posts.destroy', $blog->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i> Remove</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Pagination -->
     <div class="col-12 mt-4 d-flex justify-content-center">
    {{ $posts->links('pagination::bootstrap-5') }}
</div>
    </div>
        </div>
              </div>




              @endsection
