@extends('admin.layouts.app')
@section('title', 'Add Categories')
@section('page-title', 'Add Categorie')

@section('content')
          <div class="content-wrapper">
            <div class="row">
            
 <div class="container mt-4">
      <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0"><i class="fas fa-tag text-success me-2"></i>Blog Categories</h2>
        <a href="{{ route('admin.categories.create') }}" class="btn btn-success rounded-pill px-4">
            <i class="fas fa-plus me-2"></i>Add New Category
        </a>
    </div>

  

    <table class="table  table-striped " id="blogsTable">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($categories as $key => $category)
                <tr>
                    <td>{{ ++$key }}</td>
                    <td>{{ $category->name }}</td>
                    <td>
                        <a href="{{ route('admin.categories.edit', $category->id) }}" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i> Update</a>
                        <form action="{{ route('admin.categories.destroy', $category->id) }}" method="POST" class="d-inline">
                            @csrf @method('DELETE')
                            <button class="btn btn-danger btn-sm" onclick="return confirm('Delete this category?')"><i class="fas fa-trash"></i> Remove</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $categories->links() }}
</div>
        </div>
              </div>
        

@push('scripts')
    <!-- jQuery and Datatables JS -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#blogsTable').DataTable({
                "paging": true, // Enable pagination
                "lengthChange": false, // Disable entries per page change
                "searching": true, // Enable search
                "ordering": true, // Enable column sorting
                "info": true, // Show information about current page
            });
        });
    </script>
@endpush

@endsection