@extends('admin.layouts.app')

@section('title', 'View Contact Message')
@section('page-title', 'View Contact Message')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light text-white d-flex justify-content-between align-items-center rounded-top">
                <h5 class="mb-0 d-flex align-items-center text-dark">
                    <i class="fas fa-envelope me-2"></i>
                    Contact Message Details
                    @if(!$contact->is_read)
                        <span class="badge bg-info text-dark ms-3">New</span>
                    @endif
                </h5>
                <form action="{{ route('admin.contacts.destroy', $contact) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this message?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-sm btn-danger">
                        <i class="fas fa-trash me-1"></i> Remove
                    </button>
                </form>
            </div>
            <div class="card-body px-4 py-3">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <table class="table table-sm table-borderless">
                            <tbody>
                                <tr>
                                    <th class="text-muted" width="150">Name:</th>
                                    <td>{{ $contact->name }}</td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Email:</th>
                                    <td><a href="mailto:{{ $contact->email }}">{{ $contact->email }}</a></td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Phone:</th>
                                    <td>{{ $contact->phone ?: 'Not provided' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Subject:</th>
                                    <td>{{ $contact->subject ?: 'No subject' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Status:</th>
                                    <td>
                                        @if($contact->is_read)
                                            <span class="badge bg-success">Read</span>
                                        @else
                                            <span class="badge bg-warning text-dark">Unread</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Received At:</th>
                                    <td>{{ $contact->created_at->format('M d, Y h:i A') }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="col-md-6 text-center">
                        <div class="bg-light rounded p-3 shadow-sm h-100 d-flex flex-column justify-content-center">
                            <h6 class="text-dark mb-3">Quick Actions</h6>
                            <div class="d-grid gap-2">
                                <a href="mailto:{{ $contact->email }}" class="btn btn-outline-primary">
                                    <i class="fas fa-reply me-2"></i> Reply via Email
                                </a>
                                @if($contact->phone)
                                    <a href="tel:{{ $contact->phone }}" class="btn btn-outline-success">
                                        <i class="fas fa-phone me-2"></i> Call {{ $contact->phone }}
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="text-dark">Message</h6>
                        <div class="bg-white border rounded p-3 shadow-sm">
                            {!! nl2br(e($contact->message)) !!}
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between">
                    <a href="{{ route('admin.contacts.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-2"></i> Back to Messages
                    </a>
                    <a href="mailto:{{ $contact->email }}" class="btn btn-success">
                        <i class="fas fa-reply me-2"></i> Reply to {{ $contact->name }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
