<!-- resources/views/admin/courses/edit.blade.php -->
@extends('admin.layouts.app')

@section('title', 'Edit Course')
@section('page-title', 'Edit Course')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="fas fa-edit"></i> Edit Course</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.courses.update', $course) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <!-- Basic Information -->
                    <div class="card mb-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="fas fa-info-circle"></i> Basic Information</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">Course Title <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('title') is-invalid @enderror" 
                                               id="title" name="title" value="{{ old('title', $course->title) }}" 
                                               placeholder="Enter course title" required>
                                        @error('title')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="slug" class="form-label">Slug</label>
                                        <input type="text" class="form-control @error('slug') is-invalid @enderror" 
                                               id="slug" name="slug" value="{{ old('slug', $course->slug) }}" 
                                               placeholder="Auto-generated from title">
                                        @error('slug')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Course Description <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('description') is-invalid @enderror" 
                                          id="description" name="description" rows="4" 
                                          placeholder="Enter course description" required>{{ old('description', $course->description) }}</textarea>
                                @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="category_id" class="form-label">Category <span class="text-danger">*</span></label>
                                        <select class="form-select @error('category_id') is-invalid @enderror" 
                                                id="category_id" name="category_id" required>
                                            <option value="">Select Category</option>
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}" 
                                                    {{ old('category_id', $course->category_id) == $category->id ? 'selected' : '' }}>
                                                    {{ $category->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('category_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="teacher_id" class="form-label">Teacher <span class="text-danger">*</span></label>
                                        <select class="form-select @error('teacher_id') is-invalid @enderror" 
                                                id="teacher_id" name="teacher_id" required>
                                            <option value="">Select Teacher</option>
                                            @foreach($teachers as $teacher)
                                                <option value="{{ $teacher->id }}" 
                                                    {{ old('teacher_id', $course->teacher_id) == $teacher->id ? 'selected' : '' }}>
                                                    {{ $teacher->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('teacher_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Course Details -->
                    <div class="card mb-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="fas fa-cog"></i> Course Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="level" class="form-label">Level <span class="text-danger">*</span></label>
                                        <select class="form-select @error('level') is-invalid @enderror" 
                                                id="level" name="level" required>
                                            <option value="">Select Level</option>
                                            <option value="beginner" {{ old('level', $course->level) == 'beginner' ? 'selected' : '' }}>Beginner</option>
                                            <option value="intermediate" {{ old('level', $course->level) == 'intermediate' ? 'selected' : '' }}>Intermediate</option>
                                            <option value="advanced" {{ old('level', $course->level) == 'advanced' ? 'selected' : '' }}>Advanced</option>
                                        </select>
                                        @error('level')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="duration_value" class="form-label">Duration <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="number" class="form-control @error('duration_value') is-invalid @enderror" 
                                                   id="duration_value" name="duration_value" value="{{ old('duration_value', $course->duration_value) }}" 
                                                   min="1" required>
                                            <select class="form-select @error('duration_type') is-invalid @enderror" 
                                                    id="duration_type" name="duration_type" required>
                                                <option value="hours" {{ old('duration_type', $course->duration_type) == 'hours' ? 'selected' : '' }}>Hours</option>
                                                <option value="days" {{ old('duration_type', $course->duration_type) == 'days' ? 'selected' : '' }}>Days</option>
                                                <option value="weeks" {{ old('duration_type', $course->duration_type) == 'weeks' ? 'selected' : '' }}>Weeks</option>
                                                <option value="months" {{ old('duration_type', $course->duration_type) == 'months' ? 'selected' : '' }}>Months</option>
                                            </select>
                                        </div>
                                        @error('duration_value')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        @error('duration_type')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="label" class="form-label">Label</label>
                                        <select class="form-select @error('label') is-invalid @enderror" 
                                                id="label" name="label">
                                            <option value="">No Label</option>
                                            <option value="new" {{ old('label', $course->label) == 'new' ? 'selected' : '' }}>New</option>
                                            <option value="popular" {{ old('label', $course->label) == 'popular' ? 'selected' : '' }}>Popular</option>
                                            <option value="featured" {{ old('label', $course->label) == 'featured' ? 'selected' : '' }}>Featured</option>
                                        </select>
                                        @error('label')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="price_type" class="form-label">Price Type <span class="text-danger">*</span></label>
                                        <select class="form-select @error('price_type') is-invalid @enderror" 
                                                id="price_type" name="price_type" required>
                                            <option value="">Select Type</option>
                                            <option value="free" {{ old('price_type', $course->price_type) == 'free' ? 'selected' : '' }}>Free</option>
                                            <option value="paid" {{ old('price_type', $course->price_type) == 'paid' ? 'selected' : '' }}>Paid</option>
                                        </select>
                                        @error('price_type')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="price" class="form-label">Price ($)</label>
                                        <input type="number" class="form-control @error('price') is-invalid @enderror" 
                                               id="price" name="price" value="{{ old('price', $course->price) }}" 
                                               min="0" step="0.01">
                                        @error('price')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <div class="form-text">Required only for paid courses</div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="ratings" class="form-label">Ratings</label>
                                        <input type="number" class="form-control @error('ratings') is-invalid @enderror" 
                                               id="ratings" name="ratings" value="{{ old('ratings', $course->ratings) }}" 
                                               min="0" max="5" step="0.1">
                                        @error('ratings')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="total_students" class="form-label">Total Students</label>
                                        <input type="number" class="form-control @error('total_students') is-invalid @enderror" 
                                               id="total_students" name="total_students" value="{{ old('total_students', $course->total_students) }}" 
                                               min="0">
                                        @error('total_students')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="image" class="form-label">Course Image</label>
                                        <input type="file" class="form-control @error('image') is-invalid @enderror" 
                                               id="image" name="image" accept="image/*">
                                        @error('image')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror>
                                        <div class="form-text">Upload image to public/courses folder</div>
                                        
                                        @if($course->image)
                                            <div class="mt-2">
                                                <small>Current Image:</small><br>
                                                <img src="{{ asset($course->image) }}" 
                                                     class="img-thumbnail mt-1" style="max-height: 100px;">
                                                <div class="form-check mt-1">
                                                    <input class="form-check-input" type="checkbox" id="remove_image" name="remove_image" value="1">
                                                    <label class="form-check-label text-danger" for="remove_image">
                                                        Remove current image
                                                    </label>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Course Content -->
                    <div class="card mb-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="fas fa-book-open"></i> Course Content</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="requirements" class="form-label">Requirements</label>
                                <textarea class="form-control @error('requirements') is-invalid @enderror" 
                                          id="requirements" name="requirements" rows="3" 
                                          placeholder="Enter course requirements (one per line)">{{ old('requirements', $course->requirements) }}</textarea>
                                @error('requirements')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Enter each requirement on a new line</div>
                            </div>

                            <div class="mb-3">
                                <label for="what_you_learn" class="form-label">What You'll Learn</label>
                                <textarea class="form-control @error('what_you_learn') is-invalid @enderror" 
                                          id="what_you_learn" name="what_you_learn" rows="3" 
                                          placeholder="Enter learning outcomes (one per line)">{{ old('what_you_learn', $course->what_you_learn) }}</textarea>
                                @error('what_you_learn')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Enter each learning outcome on a new line</div>
                            </div>
                        </div>
                    </div>

                    <!-- SEO Settings -->
                    <div class="card mb-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="fas fa-search"></i> SEO Settings</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="meta_title" class="form-label">Meta Title</label>
                                <input type="text" class="form-control @error('meta_title') is-invalid @enderror" 
                                       id="meta_title" name="meta_title" value="{{ old('meta_title', $course->meta_title) }}" 
                                       placeholder="Enter meta title for SEO">
                                @error('meta_title')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="meta_description" class="form-label">Meta Description</label>
                                <textarea class="form-control @error('meta_description') is-invalid @enderror" 
                                          id="meta_description" name="meta_description" rows="2"
                                          placeholder="Enter meta description for SEO">{{ old('meta_description', $course->meta_description) }}</textarea>
                                @error('meta_description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                <input type="text" class="form-control @error('meta_keywords') is-invalid @enderror" 
                                       id="meta_keywords" name="meta_keywords" value="{{ old('meta_keywords', $course->meta_keywords) }}" 
                                       placeholder="keyword1, keyword2, keyword3">
                                @error('meta_keywords')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Settings -->
                    <div class="card mb-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="fas fa-sliders-h"></i> Settings</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3 form-check">
                                        <input type="checkbox" class="form-check-input" id="has_certificate" 
                                               name="has_certificate" value="1" {{ old('has_certificate', $course->has_certificate) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="has_certificate">
                                            Includes Certificate
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3 form-check">
                                        <input type="checkbox" class="form-check-input" id="is_active" 
                                               name="is_active" value="1" {{ old('is_active', $course->is_active) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            Active Course
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3 form-check">
                                        <input type="checkbox" class="form-check-input" id="is_featured" 
                                               name="is_featured" value="1" {{ old('is_featured', $course->is_featured) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_featured">
                                            Featured Course
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="{{ route('admin.courses.index') }}" class="btn btn-secondary me-md-2">
                            <i class="fas fa-arrow-left"></i> Back to Courses
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Course
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Auto-generate slug from title
    document.getElementById('title').addEventListener('input', function() {
        const title = this.value;
        const slugField = document.getElementById('slug');
        
        if (!slugField.value || slugField.value === '{{ $course->slug }}') {
            slugField.value = title.toLowerCase()
                .replace(/ /g, '-')
                .replace(/[^\w-]+/g, '');
        }
    });

    // Handle price field based on price type
    document.getElementById('price_type').addEventListener('change', function() {
        const priceField = document.getElementById('price');
        if (this.value === 'free') {
            priceField.value = '0';
            priceField.disabled = true;
        } else {
            priceField.disabled = false;
            if (priceField.value === '0') {
                priceField.value = '';
            }
        }
    });

    // Trigger change event on page load
    document.getElementById('price_type').dispatchEvent(new Event('change'));
</script>
@endpush