<!-- resources/views/admin/courses/show.blade.php -->
@extends('admin.layouts.app')

@section('title', $course->title)
@section('page-title', 'Course Details')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card shadow">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <h4 class="mb-0"><i class="fas fa-book"></i> Course Details</h4>
                <div class="btn-group">
                    <a href="{{ route('admin.courses.edit', $course) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <form action="{{ route('admin.courses.destroy', $course) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" 
                                onclick="return confirm('Are you sure?')">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-4">
                        @if($course->image)
                            <img src="{{ asset($course->image) }}" 
                                 class="img-fluid rounded" alt="{{ $course->title }}">
                        @else
                            <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                 style="height: 200px;">
                                <i class="fas fa-image text-muted" style="font-size: 3rem;"></i>
                            </div>
                        @endif
                    </div>
                    <div class="col-md-8">
                        <h2 class="mb-3">{{ $course->title }}</h2>
                        
                        <div class="d-flex flex-wrap gap-2 mb-3">
                            @if($course->label)
                                <span class="badge label-{{ $course->label }} text-white bg-success px-3 py-2">
                                    {{ ucfirst($course->label) }}
                                </span>
                            @endif
                            <span class="badge bg-secondary">{{ ucfirst($course->level) }}</span>
                            <span class="badge bg-info">{{ $course->duration_value }} {{ $course->duration_type }}</span>
                            @if($course->has_certificate)
                                <span class="badge bg-success">
                                    <i class="fas fa-award"></i> Certificate Included
                                </span>
                            @endif
                        </div>

                        <div class="mb-3">
                            <div class="rating-stars h5">
                                @php
                                    $fullStars = floor($course->ratings);
                                    $halfStar = ($course->ratings - $fullStars) >= 0.5 ? 1 : 0;
                                    $emptyStars = 5 - ($fullStars + $halfStar);
                                @endphp

                                @for ($i = 1; $i <= $fullStars; $i++)
                                    <i class="fas fa-star text-warning"></i>
                                @endfor

                                @if ($halfStar)
                                    <i class="fas fa-star-half-alt text-warning"></i>
                                @endif

                                @for ($i = 1; $i <= $emptyStars; $i++)
                                    <i class="far fa-star text-warning"></i>
                                @endfor
                                <span class="text-muted">({{ number_format($course->ratings, 1) }})</span>
                            </div>
                        </div>

                        <div class="row text-center mb-3">
                            <div class="col-4">
                                <div class="border-end">
                                    <h5 class="text-primary mb-1">{{ $course->total_students }}</h5>
                                    <small class="text-muted">Students</small>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="border-end">
                                    <h5 class="text-success mb-1">{{ $course->duration_value }}</h5>
                                    <small class="text-muted">{{ ucfirst($course->duration_type) }}</small>
                                </div>
                            </div>
                            <div class="col-4">
                                <h5 class="text-warning mb-1">{{ $course->category->name }}</h5>
                                <small class="text-muted">Category</small>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="mb-0">
                                    @if($course->price_type === 'free')
                                        <span class="text-success">Free</span>
                                    @else
                                        <span class="text-primary">${{ number_format($course->price, 2) }}</span>
                                    @endif
                                </h4>
                            </div>
                            <div class="text-end">
                                <small class="text-muted d-block">Instructor</small>
                                <strong>{{ $course->teacher->name }}</strong>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-4">
                    <h5>Description</h5>
                    <p class="text-muted">{{ $course->description }}</p>
                </div>

                @if($course->requirements)
                <div class="mb-4">
                    <h5>Requirements</h5>
                    <div class="text-muted">
                        @foreach(explode("\n", $course->requirements) as $requirement)
                            @if(trim($requirement))
                                <div class="d-flex align-items-center mb-1">
                                    <i class="fas fa-check text-success me-2"></i>
                                    <span>{{ $requirement }}</span>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
                @endif

                @if($course->what_you_learn)
                <div class="mb-4">
                    <h5>What You'll Learn</h5>
                    <div class="text-muted">
                        @foreach(explode("\n", $course->what_you_learn) as $learning)
                            @if(trim($learning))
                                <div class="d-flex align-items-center mb-1">
                                    <i class="fas fa-check text-primary me-2"></i>
                                    <span>{{ $learning }}</span>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="fas fa-info-circle"></i> Course Information</h5>
            </div>
            <div class="card-body">
                <div class="list-group list-group-flush">
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Category:</span>
                        <strong>{{ $course->category->name }}</strong>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Level:</span>
                        <span class="badge bg-secondary">{{ ucfirst($course->level) }}</span>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Duration:</span>
                        <strong>{{ $course->duration_value }} {{ $course->duration_type }}</strong>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Price Type:</span>
                        <span class="badge bg-{{ $course->price_type === 'free' ? 'success' : 'primary' }}">
                            {{ ucfirst($course->price_type) }}
                        </span>
                    </div>
                    @if($course->price_type === 'paid')
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Price:</span>
                        <strong>${{ number_format($course->price, 2) }}</strong>
                    </div>
                    @endif
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Certificate:</span>
                        <span class="badge bg-{{ $course->has_certificate ? 'success' : 'secondary' }}">
                            {{ $course->has_certificate ? 'Yes' : 'No' }}
                        </span>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Total Students:</span>
                        <strong>{{ $course->total_students }}</strong>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Status:</span>
                        <span class="badge bg-{{ $course->is_active ? 'success' : 'danger' }}">
                            {{ $course->is_active ? 'Active' : 'Inactive' }}
                        </span>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Featured:</span>
                        <span class="badge bg-{{ $course->is_featured ? 'warning' : 'secondary' }}">
                            {{ $course->is_featured ? 'Yes' : 'No' }}
                        </span>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Created:</span>
                        <small class="text-muted">{{ $course->created_at->format('M d, Y') }}</small>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="fas fa-chalkboard-teacher"></i> Teacher Information</h5>
            </div>
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    @if($course->teacher->profile_image)
                        <img src="{{ asset($course->teacher->profile_image) }}" 
                             class="rounded-circle me-3" width="50" height="50" 
                             style="object-fit: cover;" alt="{{ $course->teacher->name }}">
                    @else
                        <div class="bg-light rounded-circle d-flex align-items-center justify-content-center me-3" 
                             style="width: 50px; height: 50px;">
                            <i class="fas fa-user text-muted"></i>
                        </div>
                    @endif
                    <div>
                        <h6 class="mb-0">{{ $course->teacher->name }}</h6>
                        @if($course->teacher->specialization)
                            <small class="text-muted">{{ $course->teacher->specialization }}</small>
                        @endif
                    </div>
                </div>
                @if($course->teacher->email)
                    <div class="mb-2">
                        <small><i class="fas fa-envelope text-muted me-2"></i> {{ $course->teacher->email }}</small>
                    </div>
                @endif
                @if($course->teacher->experience_years > 0)
                    <div class="mb-2">
                        <small><i class="fas fa-briefcase text-muted me-2"></i> {{ $course->teacher->experience_years }} years experience</small>
                    </div>
                @endif
            </div>
        </div>
        
        <div class="mt-3 text-center">
            <a href="{{ route('admin.courses.index') }}" class="btn btn-outline-primary">
                <i class="fas fa-arrow-left"></i> Back to Courses
            </a>
        </div>
    </div>
</div>
@endsection