@extends('admin.layouts.app')

@section('title', 'Update Enrollment Status')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="fw-bold text-dark">
                    <i class="fas fa-edit me-2 text-primary"></i> Update Enrollment Status
                </h1>
                <a href="{{ route('admin.enrollments.index') }}" class="btn btn-secondary shadow-sm">
                    <i class="fas fa-arrow-left me-2"></i> Back to Enrollments
                </a>
            </div>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card border-0 shadow-lg">
                <div class="card-header bg-gradient-primary text-dark d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-user-graduate me-2"></i> Enrollment #{{ $enrollment->enrollment_code }}</h5>
                    <span class="badge bg-light text-dark px-3 py-2">
                        <i class="fas fa-clock me-1"></i> {{ $enrollment->created_at->format('M d, Y') }}
                    </span>
                </div>

                <div class="card-body bg-light">
                    <div class="p-3 bg-white rounded-3 shadow-sm mb-4">
                        <h5 class="mb-3 text-primary"><i class="fas fa-info-circle me-2"></i> Student Information</h5>
                        <p class="mb-1"><strong><i class="fas fa-user me-2 text-secondary"></i>Name:</strong> {{ $enrollment->first_name }} {{ $enrollment->last_name }}</p>
                        <p class="mb-1"><strong><i class="fas fa-book-open me-2 text-secondary"></i>Course:</strong> {{ $enrollment->course->title }}</p>
                        <p class="mb-1">
                            <strong><i class="fas fa-signal me-2 text-secondary"></i>Current Status:</strong>
                            @if($enrollment->status == 'pending')
                                <span class="badge bg-warning text-dark"><i class="fas fa-hourglass-half me-1"></i> Pending</span>
                            @elseif($enrollment->status == 'confirmed')
                                <span class="badge bg-success"><i class="fas fa-check-circle me-1"></i> Confirmed</span>
                            @elseif($enrollment->status == 'completed')
                                <span class="badge bg-info text-dark"><i class="fas fa-flag-checkered me-1"></i> Completed</span>
                            @else
                                <span class="badge bg-danger"><i class="fas fa-times-circle me-1"></i> Cancelled</span>
                            @endif
                        </p>
                    </div>

                    <form action="{{ route('admin.enrollments.update', $enrollment->id) }}" method="POST" class="bg-white p-4 rounded-3 shadow-sm">
                        @csrf
                        @method('PUT')

                        <div class="mb-3">
                            <label class="form-label fw-bold text-dark"><i class="fas fa-sync-alt me-2 text-primary"></i>New Status</label>
                            <select name="status" class="form-select shadow-sm border-primary" required>
                                <option value="pending" {{ $enrollment->status == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="confirmed" {{ $enrollment->status == 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                                <option value="completed" {{ $enrollment->status == 'completed' ? 'selected' : '' }}>Completed</option>
                                <option value="cancelled" {{ $enrollment->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            </select>
                        </div>

                        <div class="d-grid gap-3 mt-4">
                            <button type="submit" class="btn btn-primary shadow-sm">
                                <i class="fas fa-save me-2"></i> Update Status
                            </button>
                            <a href="{{ route('admin.enrollments.show', $enrollment->id) }}" class="btn btn-outline-secondary shadow-sm">
                                <i class="fas fa-eye me-2"></i> View Details
                            </a>
                        </div>
                    </form>
                </div>

                <div class="card-footer text-center bg-white border-0">
                    <small class="text-muted"><i class="fas fa-lock me-1"></i> Changes will be logged for audit purposes</small>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
