@extends('admin.layouts.app')

@section('title', 'FAQs Management')
@section('page-title', 'FAQs Management')

@section('content')
<div class="container-fluid">

  <!-- Header -->
  <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
    <h2 class="fw-bold text-dark mb-0">
      <i class="fas fa-question-circle text-success me-2"></i>FAQs
    </h2>
    <a href="{{ route('admin.faqs.create') }}" class="btn btn-success rounded-pill px-4">
      <i class="fas fa-plus me-2"></i>Add FAQ
    </a>
  </div>

  <!-- Card -->
  <div class="card border-0 rounded-4 shadow-sm">
    <div class="card-body p-4">

      @if($faqs->count())
        <div class="table-responsive">
          <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th class="fw-semibold">#</th>
                <th class="fw-semibold">Question</th>
                <th class="fw-semibold">Status</th>
                <th class="fw-semibold">Order</th>
                <th class="fw-semibold">Created</th>
                <th class="fw-semibold text-center">Actions</th>
              </tr>
            </thead>
            <tbody>
              @foreach($faqs as $f)
              <tr>
                <td>{{ $f->id }}</td>
                <td class="text-truncate" style="max-width: 250px;">{{ $f->question }}</td>
                <td>
                  <span class="badge rounded-pill {{ $f->is_active ? 'bg-success' : 'bg-secondary' }}">
                    {{ $f->is_active ? 'Active' : 'Inactive' }}
                  </span>
                </td>
                <td>{{ $f->sort_order }}</td>
                <td>{{ $f->created_at->format('M d, Y') }}</td>
                <td class="text-center">
                  <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                      <i class="fas fa-ellipsis-v"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                      <li><a class="dropdown-item" href="{{ route('admin.faqs.show', $f) }}"><i class="fas fa-eye text-primary me-2"></i>View</a></li>
                      <li><a class="dropdown-item" href="{{ route('admin.faqs.edit', $f) }}"><i class="fas fa-edit text-warning me-2"></i>Edit</a></li>
                      <li>
                        <form action="{{ route('admin.faqs.destroy', $f) }}" method="POST" onsubmit="return confirm('Delete this FAQ?')">
                          @csrf @method('DELETE')
                          <button type="submit" class="dropdown-item text-danger"><i class="fas fa-trash me-2"></i>Delete</button>
                        </form>
                      </li>
                    </ul>
                  </div>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>

        @if($faqs->hasPages())
          <div class="d-flex justify-content-center mt-4">
            {{ $faqs->links('pagination::bootstrap-4') }}
          </div>
        @endif

      @else
        <div class="text-center py-5">
          <i class="fas fa-question-circle fa-3x text-success opacity-75 mb-3"></i>
          <h5 class="fw-semibold text-dark mb-2">No FAQs yet</h5>
          <p class="text-muted mb-4">Add your first FAQ to get started.</p>
          <a href="{{ route('admin.faqs.create') }}" class="btn btn-success rounded-pill px-4">
            <i class="fas fa-plus me-2"></i>Add FAQ
          </a>
        </div>
      @endif

    </div>
  </div>
</div>
@endsection