@extends('admin.layouts.app')

@section('title', 'View FAQ')
@section('page-title', 'View FAQ')

@section('content')
<div class="container-fluid">
  <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
    <h2 class="fw-bold text-dark mb-0">
      <i class="fas fa-question-circle text-success me-2"></i>{{ $faq->question }}
    </h2>
    <div class="d-flex gap-2">
      <a href="{{ route('admin.faqs.edit', $faq) }}" class="btn btn-outline-success rounded-pill">
        <i class="fas fa-edit me-1"></i>Edit
      </a>
      <form action="{{ route('admin.faqs.destroy', $faq) }}" method="POST"
            onsubmit="return confirm('Delete this FAQ?')" class="d-inline">
        @csrf @method('DELETE')
        <button type="submit" class="btn btn-outline-danger rounded-pill">
          <i class="fas fa-trash me-1"></i>Delete
        </button>
      </form>
    </div>
  </div>

  <div class="row g-4">
    <!-- Details -->
    <div class="col-lg-8">
      <div class="card border-0 rounded-4 shadow-sm h-100">
        <div class="card-body p-4">
          <table class="table table-borderless mb-0">
            <tr><th width="150" class="text-muted">ID</th><td>{{ $faq->id }}</td></tr>
            <tr>
              <th class="text-muted">Question</th>
              <td class="fw-semibold">{{ $faq->question }}</td>
            </tr>
            <tr>
              <th class="text-muted">Answer</th>
              <td><div class="bg-light rounded-3 p-3">{!! nl2br(e($faq->answer)) !!}</div></td>
            </tr>
            <tr>
              <th class="text-muted">Sort Order</th>
              <td><span class="badge rounded-pill bg-info">{{ $faq->sort_order }}</span></td>
            </tr>
            <tr>
              <th class="text-muted">Status</th>
              <td>
                <span class="badge rounded-pill {{ $faq->is_active ? 'bg-success' : 'bg-secondary' }}">
                  {{ $faq->is_active ? 'Active' : 'Inactive' }}
                </span>
              </td>
            </tr>
            <tr><th class="text-muted">Created</th><td>{{ $faq->created_at->format('M d, Y h:i A') }}</td></tr>
            <tr><th class="text-muted">Updated</th><td>{{ $faq->updated_at->format('M d, Y h:i A') }}</td></tr>
          </table>
        </div>
      </div>
    </div>

    <!-- Preview -->
    <div class="col-lg-4">
      <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4 text-center">
          <i class="fas fa-question-circle fa-4x text-primary mb-3"></i>
          <h6 class="fw-semibold">FAQ Preview</h6>
          <div class="accordion mt-3" id="faqPreview">
            <div class="accordion-item">
              <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePreview">
                  {{ Str::limit($faq->question, 50) }}
                </button>
              </h2>
              <div id="collapsePreview" class="accordion-collapse collapse" data-bs-parent="#faqPreview">
                <div class="accordion-body">
                  {{ Str::limit($faq->answer, 100) }}
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="text-center mt-4">
    <a href="{{ route('admin.faqs.index') }}" class="btn btn-outline-secondary rounded-pill px-4">
      <i class="fas fa-arrow-left me-2"></i>Back to List
    </a>
  </div>
</div>
@endsection