@extends('admin.layouts.app')

@section('title', 'Edit Home Content')
@section('page-title', 'Edit Home Content')
@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0">Edit Home Content</h2>
        <a href="{{ route('admin.home.index') }}" class="btn btn-outline-secondary rounded-pill">
            <i class="fas fa-arrow-left me-2"></i>Back
        </a>
    </div>

    <!-- Form Card -->
    <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">
            <form action="{{ route('admin.home.update', $home) }}" method="POST" enctype="multipart/form-data">
                @csrf @method('PUT')

                <!-- Row 1 -->
                <div class="row g-3 mb-3">
                    <div class="col-md-12">
                        <label class="form-label fw-semibold">Title <span class="text-danger">*</span></label>
                        <input type="text" name="title" value="{{ old('title', $home->title) }}"
                               class="form-control rounded-3 @error('title') is-invalid @enderror" required>
                        @error('title') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                
                </div>

                <!-- Row 2 -->
                <div class="row g-3 mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Hero Heading <span class="text-danger">*</span></label>
                        <input type="text" name="hero_heading" value="{{ old('hero_heading', $home->hero_heading) }}"
                               class="form-control rounded-3 @error('hero_heading') is-invalid @enderror" required>
                        @error('hero_heading') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Button Text <span class="text-danger">*</span></label>
                        <input type="text" name="button_text" value="{{ old('button_text', $home->button_text) }}"
                               class="form-control rounded-3 @error('button_text') is-invalid @enderror" required>
                        @error('button_text') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>

                <!-- Button Link -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Button Link <span class="text-danger">*</span></label>
                    <input type="url" name="button_link" value="{{ old('button_link', $home->button_link) }}"
                           class="form-control rounded-3 @error('button_link') is-invalid @enderror" required>
                    @error('button_link') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <!-- Description -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Description <span class="text-danger">*</span></label>
                    <textarea name="description" rows="4"
                              class="form-control rounded-3 @error('description') is-invalid @enderror" required>{{ old('description', $home->description) }}</textarea>
                    @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <!-- Image -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Image</label>
                    @if($home->image)
                        <div class="mb-2">
                            <img src="{{ $home->image_url }}" alt="Current" class="rounded-3 border" style="max-height: 160px; object-fit: cover;">
                        </div>
                    @endif
                    <input type="file" name="image" accept="image/*"
                           class="form-control rounded-3 @error('image') is-invalid @enderror">
                    <div class="form-text small">JPEG, PNG, JPG, GIF ≤ 2 MB. Leave blank to keep current image.</div>
                    @error('image') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <!-- Active toggle -->
                <div class="form-check mb-4">
                    <input class="form-check-input" type="checkbox" name="is_active" value="1"
                           id="is_active" {{ old('is_active', $home->is_active) ? 'checked' : '' }}>
                    <label class="form-check-label fw-semibold" for="is_active">Active</label>
                </div>

                <!-- Footer buttons -->
                <div class="d-flex flex-column flex-sm-row justify-content-between gap-2">
                    <a href="{{ route('admin.home.index') }}" class="btn btn-outline-secondary rounded-pill">
                        <i class="fas fa-arrow-left me-2"></i>Cancel
                    </a>
                    <button type="submit" class="btn btn-success rounded-pill px-4">
                        <i class="fas fa-save me-2"></i>Update Content
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection