@extends('admin.layouts.app')

@section('title', 'View Home Content')
@section('page-title', 'View Home Content')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0">View Home Content</h2>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.home.edit', $home) }}" class="btn btn-outline-success rounded-pill px-3">
                <i class="fas fa-edit me-1"></i>Edit
            </a>
            <form action="{{ route('admin.home.destroy', $home) }}" method="POST"
                  onsubmit="return confirm('Delete this content?')" class="d-inline">
                @csrf @method('DELETE')
                <button type="submit" class="btn btn-outline-danger rounded-pill px-3">
                    <i class="fas fa-trash me-1"></i>Delete
                </button>
            </form>
        </div>
    </div>

    <!-- Detail Card -->
    <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">
            <div class="row g-4">
                <!-- Left: Data -->
                <div class="col-lg-8">
                    <div class="row mb-3">
                        <div class="col-5 col-sm-3 fw-semibold text-muted">Title</div>
                        <div class="col">{{ $home->title }}</div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-5 col-sm-3 fw-semibold text-muted">Subtitle</div>
                        <div class="col">{{ $home->subtitle }}</div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-5 col-sm-3 fw-semibold text-muted">Hero Heading</div>
                        <div class="col">{{ $home->hero_heading }}</div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-5 col-sm-3 fw-semibold text-muted">Button Text</div>
                        <div class="col">{{ $home->button_text }}</div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-5 col-sm-3 fw-semibold text-muted">Button Link</div>
                        <div class="col">
                            <a href="{{ $home->button_link }}" target="_blank" class="link-success text-decoration-none">
                                {{ $home->button_link }} <i class="fas fa-external-link-alt fa-xs ms-1"></i>
                            </a>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-5 col-sm-3 fw-semibold text-muted">Status</div>
                        <div class="col">
                            <span class="badge rounded-pill {{ $home->is_active ? 'bg-success' : 'bg-secondary' }}">
                                {{ $home->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-5 col-sm-3 fw-semibold text-muted">Created</div>
                        <div class="col">{{ $home->created_at->format('M d, Y h:i A') }}</div>
                    </div>
                    <div class="row">
                        <div class="col-5 col-sm-3 fw-semibold text-muted">Updated</div>
                        <div class="col">{{ $home->updated_at->format('M d, Y h:i A') }}</div>
                    </div>
                </div>

                <!-- Right: Image -->
                <div class="col-lg-4">
                    @if($home->image)
                        <img src="{{ asset('home/' .$home->image ?? 'assets/img/education/courses-13.webp') }}" alt="Home Image"
                             class="img-fluid rounded-4 shadow-sm w-100" style="max-height: 260px; object-fit: cover;">
                    @else
                        <div class="bg-light rounded-4 d-flex align-items-center justify-content-center"
                             style="height: 260px;">
                            <div class="text-center text-muted">
                                <i class="fas fa-image fa-3x mb-2"></i>
                                <div>No Image</div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Description -->
            <div class="mt-5">
                <h5 class="fw-bold mb-3 text-dark">Description</h5>
                <div class="bg-light rounded-4 p-4 text-secondary">
                    {!! nl2br(e($home->description)) !!}
                </div>
            </div>

            <!-- Footer Actions -->
            <div class="d-flex flex-column flex-sm-row justify-content-between gap-2 mt-4 pt-4 border-top">
                <a href="{{ route('admin.home.index') }}" class="btn btn-outline-secondary rounded-pill px-4">
                    <i class="fas fa-arrow-left me-2"></i>Back to List
                </a>
                <a href="{{ route('admin.home.edit', $home) }}" class="btn btn-success rounded-pill px-4">
                    <i class="fas fa-edit me-2"></i>Edit Content
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
