@extends('admin.layouts.app')

@section('title', 'Services Management')
@section('page-title', 'Services Management')

@section('content')
<div class="container-fluid">

    <!-- Header -->
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0">
            <i class="fas fa-cogs text-success me-2"></i>Services
        </h2>
        <a href="{{ route('admin.services.create') }}" class="btn btn-success rounded-pill px-4">
            <i class="fas fa-plus me-2"></i>Add Service
        </a>
    </div>

    <!-- Card -->
    <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">
@if($services->count())
    <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
                <tr>
                    <th class="fw-semibold">#</th>
                    <th class="fw-semibold">Title</th>
                    <th class="fw-semibold">Status</th>
                    <th class="fw-semibold">Images</th>
                    <th class="fw-semibold">Created</th>
                    <th class="fw-semibold text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($services as $s)
                <tr>
                    <td>{{ $s->id }}</td>
                    <td class="text-truncate" style="max-width: 200px;">{{ $s->title }}</td>
                    <td>
                        <span class="badge rounded-pill {{ $s->is_active ? 'bg-success' : 'bg-secondary' }}">
                            {{ $s->is_active ? 'Active' : 'Inactive' }}
                        </span>
                    </td>
                 <td>
    @if($s->image_1 || $s->image_2)
        @if($s->image_1)
            <img src="{{ url('services/' . $s->image_1) }}" alt="Image" class="img-thumbnail" style="width: 50px; height: 50px; object-fit: cover;">
        @endif

    @else
        <span class="text-muted">No Image</span>
    @endif
</td>

                        </div>
                    </td>
                    <td>{{ $s->created_at->format('M d, Y') }}</td>
                    <td class="text-center">
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                <i class="fas fa-ellipsis-v"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                             
                                <li><a class="dropdown-item" href="{{ route('admin.services.edit', $s) }}"><i class="fas fa-edit text-warning me-2"></i>Edit</a></li>
                                <li>
                                    <form action="{{ route('admin.services.destroy', $s) }}" method="POST" onsubmit="return confirm('Delete this service?')">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="dropdown-item text-danger"><i class="fas fa-trash me-2"></i>Delete</button>
                                    </form>
                                </li>
                            </ul>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody> <!-- ✅ Close tbody after the loop -->
        </table>
    </div>

    @if($services->hasPages())
        <div class="d-flex justify-content-center mt-4">
            {{ $services->links('pagination::bootstrap-4') }}
        </div>
    @endif

@else
    <!-- Empty State -->
    <div class="text-center py-5">
        <i class="fas fa-cogs fa-3x text-success opacity-75 mb-3"></i>
        <h5 class="fw-semibold text-dark mb-2">No services yet</h5>
        <p class="text-muted mb-4">Add your first service to get started.</p>
        <a href="{{ route('admin.services.create') }}" class="btn btn-success rounded-pill px-4">
            <i class="fas fa-plus me-2"></i>Add Service
        </a>
    </div>
@endif

        </div>
    </div>
</div>
@endsection