@extends('admin.layouts.app')

@section('title', 'Website Settings')
@section('page-title', 'Website Settings')

@section('content')
<div class="row">
    <div class="col-12">
        

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-cog me-2"></i>
                    Website Settings
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.settings.update', 1) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <!-- Site Information -->
                    <div class="card mb-4">
                        <div class="card-header bg-primary text-white">
                            <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Site Information</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="site_name" class="form-label">Site Name</label>
                                        <input type="text" 
                                               class="form-control @error('site_name') is-invalid @enderror" 
                                               id="site_name" 
                                               name="site_name" 
                                               value="{{ old('site_name', $setting->site_name) }}" 
                                               placeholder="AyzMedFlow">
                                        @error('site_name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="site_email" class="form-label">Site Email</label>
                                        <input type="email" 
                                               class="form-control @error('site_email') is-invalid @enderror" 
                                               id="site_email" 
                                               name="site_email" 
                                               value="{{ old('site_email', $setting->site_email) }}" 
                                               placeholder="info@ayzmedflow.com">
                                        @error('site_email')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="site_phone" class="form-label">Site Phone</label>
                                        <input type="text" 
                                               class="form-control @error('site_phone') is-invalid @enderror" 
                                               id="site_phone" 
                                               name="site_phone" 
                                               value="{{ old('site_phone', $setting->site_phone) }}" 
                                               placeholder="+1 (555) 123-4567">
                                        @error('site_phone')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="site_address" class="form-label">Site Address</label>
                                        <textarea class="form-control @error('site_address') is-invalid @enderror" 
                                                  id="site_address" 
                                                  name="site_address" 
                                                  rows="3" 
                                                  placeholder="123 Medical Center Dr, Suite 100, City, State 12345">{{ old('site_address', $setting->site_address) }}</textarea>
                                        @error('site_address')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Branding -->
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0"><i class="fas fa-image me-2"></i>Branding</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="logo" class="form-label">Logo</label>
                                        @if($setting->logo)
                                            <div class="mb-2">
                                                <img src="{{ asset($settings->logo) }}" 
                                                     alt="Current Logo" 
                                                     class="img-thumbnail" 
                                                     style="max-width: 200px; max-height: 100px;">
                                                <div class="form-text">Current logo</div>
                                            </div>
                                        @endif
                                        <input type="file" 
                                               class="form-control @error('logo') is-invalid @enderror" 
                                               id="logo" 
                                               name="logo" 
                                               accept="image/*">
                                        @error('logo')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <div class="form-text">Recommended size: 200x80px. Max size: 2MB</div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="favicon" class="form-label">Favicon</label>
                                        @if($setting->favicon)
                                            <div class="mb-2">
                                                <img src="{{ asset($settings->favicon) }}"
                                                     alt="Current Favicon" 
                                                     class="img-thumbnail" 
                                                     style="max-width: 32px; max-height: 32px;">
                                                <div class="form-text">Current favicon</div>
                                            </div>
                                        @endif
                                        <input type="file" 
                                               class="form-control @error('favicon') is-invalid @enderror" 
                                               id="favicon" 
                                               name="favicon" 
                                               accept="image/*,.ico">
                                        @error('favicon')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <div class="form-text">Recommended size: 32x32px or 16x16px. Max size: 1MB</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Content Sections -->
                    <div class="card mb-4">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0"><i class="fas fa-edit me-2"></i>Content Sections</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="header_content" class="form-label">Header Content</label>
                                <textarea class="form-control @error('header_content') is-invalid @enderror" 
                                          id="header_content" 
                                          name="header_content" 
                                          rows="3" 
                                          placeholder="Content that appears in the website header">{{ old('header_content', $setting->header_content) }}</textarea>
                                @error('header_content')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="mb-3">
                                <label for="hero_content" class="form-label">Hero Section Content</label>
                                <textarea class="form-control @error('hero_content') is-invalid @enderror" 
                                          id="hero_content" 
                                          name="hero_content" 
                                          rows="4" 
                                          placeholder="Main hero section content on homepage">{{ old('hero_content', $setting->hero_content) }}</textarea>
                                @error('hero_content')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="mb-3">
                                <label for="footer_content" class="form-label">Footer Content</label>
                                <textarea class="form-control @error('footer_content') is-invalid @enderror" 
                                          id="footer_content" 
                                          name="footer_content" 
                                          rows="4" 
                                          placeholder="Detailed footer content">{{ old('footer_content', $setting->footer_content) }}</textarea>
                                @error('footer_content')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="mb-3">
                                <label for="footer_short_text" class="form-label">Footer Short Text</label>
                                <input type="text" 
                                       class="form-control @error('footer_short_text') is-invalid @enderror" 
                                       id="footer_short_text" 
                                       name="footer_short_text" 
                                       value="{{ old('footer_short_text', $setting->footer_short_text) }}" 
                                       placeholder=" AyzMedFlow. All rights reserved.">
                                @error('footer_short_text')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Social Media -->
                    <div class="card mb-4">
                        <div class="card-header bg-warning text-dark">
                            <h6 class="mb-0"><i class="fas fa-share-alt me-2"></i>Social Media Links</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="facebook_url" class="form-label">
                                            <i class="fab fa-facebook me-2"></i>Facebook URL
                                        </label>
                                        <input type="url" 
                                               class="form-control @error('facebook_url') is-invalid @enderror" 
                                               id="facebook_url" 
                                               name="facebook_url" 
                                               value="{{ old('facebook_url', $setting->facebook_url) }}" 
                                               placeholder="https://facebook.com/yourpage">
                                        @error('facebook_url')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="instagram_url" class="form-label">
                                            <i class="fab fa-instagram me-2"></i>Instagram URL
                                        </label>
                                        <input type="url" 
                                               class="form-control @error('instagram_url') is-invalid @enderror" 
                                               id="instagram_url" 
                                               name="instagram_url" 
                                               value="{{ old('instagram_url', $setting->instagram_url) }}" 
                                               placeholder="https://instagram.com/yourpage">
                                        @error('instagram_url')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="tiktok_url" class="form-label">
                                            <i class="fab fa-tiktok me-2"></i>TikTok URL
                                        </label>
                                        <input type="url" 
                                               class="form-control @error('tiktok_url') is-invalid @enderror" 
                                               id="tiktok_url" 
                                               name="tiktok_url" 
                                               value="{{ old('tiktok_url', $setting->tiktok_url) }}" 
                                               placeholder="https://tiktok.com/@yourpage">
                                        @error('tiktok_url')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="linkedin_url" class="form-label">
                                            <i class="fab fa-linkedin me-2"></i>LinkedIn URL
                                        </label>
                                        <input type="url" 
                                               class="form-control @error('linkedin_url') is-invalid @enderror" 
                                               id="linkedin_url" 
                                               name="linkedin_url" 
                                               value="{{ old('linkedin_url', $setting->linkedin_url) }}" 
                                               placeholder="https://linkedin.com/company/yourcompany">
                                        @error('linkedin_url')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="youtube_url" class="form-label">
                                    <i class="fab fa-youtube me-2"></i>YouTube URL
                                </label>
                                <input type="url" 
                                       class="form-control @error('youtube_url') is-invalid @enderror" 
                                       id="youtube_url" 
                                       name="youtube_url" 
                                       value="{{ old('youtube_url', $setting->youtube_url) }}" 
                                       placeholder="https://youtube.com/channel/yourchannel">
                                @error('youtube_url')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Map & SEO -->
                    <div class="card mb-4">
                        <div class="card-header bg-secondary text-white">
                            <h6 class="mb-0"><i class="fas fa-map-marker-alt me-2"></i>Map & SEO</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="map_embed_code" class="form-label">Map Embed Code</label>
                                <textarea class="form-control @error('map_embed_code') is-invalid @enderror" 
                                          id="map_embed_code" 
                                          name="map_embed_code" 
                                          rows="4" 
                                          placeholder="<iframe src='https://www.google.com/maps/embed?...' width='600' height='450' style='border:0;' allowfullscreen='' loading='lazy'></iframe>">{{ old('map_embed_code', $setting->map_embed_code) }}</textarea>
                                @error('map_embed_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Paste the embed code from Google Maps</div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="meta_description" class="form-label">Meta Description</label>
                                <textarea class="form-control @error('meta_description') is-invalid @enderror" 
                                          id="meta_description" 
                                          name="meta_description" 
                                          rows="3" 
                                          placeholder="Brief description of your website for search engines (150-160 characters)">{{ old('meta_description', $setting->meta_description) }}</textarea>
                                @error('meta_description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="mb-3">
                                <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                <textarea class="form-control @error('meta_keywords') is-invalid @enderror" 
                                          id="meta_keywords" 
                                          name="meta_keywords" 
                                          rows="2" 
                                          placeholder="medical billing, healthcare, revenue cycle management, medical practice">{{ old('meta_keywords', $setting->meta_keywords) }}</textarea>
                                @error('meta_keywords')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Separate keywords with commas</div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-save me-2"></i>Save Settings
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

