@extends('admin.layouts.app')

@section('title', 'Add Specialty')
@section('page-title', 'Add Specialty')

@section('content')
<div class="container-fluid">
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0"><i class="fas fa-plus-circle text-success me-2"></i>Add Specialty</h2>
        <a href="{{ route('admin.specialties.index') }}" class="btn btn-outline-secondary rounded-pill">
            <i class="fas fa-arrow-left me-2"></i>Back
        </a>
    </div>

    <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">
            <form action="{{ route('admin.specialties.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="mb-3">
                    <label class="form-label fw-semibold">Title <span class="text-danger">*</span></label>
                    <input type="text" name="title" value="{{ old('title') }}" class="form-control rounded-3" required>
                </div>

                  <div class="mb-3">
                    <label class="form-label fw-semibold">Short Title <span class="text-danger">*</span></label>
                    <input type="text" name="short" value="{{ old('short') }}" class="form-control rounded-3" required>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Description <span class="text-danger">*</span></label>
                    <textarea name="description" id="description" rows="4" class="form-control rounded-3" required>{{ old('description') }}</textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Image</label>
                    <input type="file" name="image" accept="image/*" class="form-control rounded-3">
                    <div class="form-text">JPG, PNG, GIF ≤ 2 MB</div>
                </div>

                <div class="form-check mb-4">
                    <input class="form-check-input" type="checkbox" name="is_active" value="1" checked>
                    <label class="form-check-label fw-semibold">Active</label>
                </div>

                <div class="d-flex flex-column flex-sm-row justify-content-between gap-2">
                    <a href="{{ route('admin.specialties.index') }}" class="btn btn-outline-secondary rounded-pill">Cancel</a>
                    <button type="submit" class="btn btn-success rounded-pill px-4">Save Specialty</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script src="https://cdn.ckeditor.com/4.21.0/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('description');
</script>
@endsection