@extends('admin.layouts.app')

@section('title', 'Edit Specialty')
@section('page-title', 'Edit Specialty')

@section('content')
<div class="container-fluid">
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0"><i class="fas fa-edit text-success me-2"></i>Edit Specialty</h2>
        <a href="{{ route('admin.specialties.index') }}" class="btn btn-outline-secondary rounded-pill">
            <i class="fas fa-arrow-left me-2"></i>Back
        </a>
    </div>

    <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">
            <form action="{{ route('admin.specialties.update', $specialty) }}" method="POST" enctype="multipart/form-data">
                @csrf @method('PUT')
                <div class="mb-3">
                    <label class="form-label fw-semibold">Title <span class="text-danger">*</span></label>
                    <input type="text" name="title" value="{{ old('title', $specialty->title) }}" class="form-control rounded-3" required>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Short Title <span class="text-danger">*</span></label>
                    <input type="text" name="short" value="{{ old('short', $specialty->short) }}" class="form-control rounded-3" required>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Description <span class="text-danger">*</span></label>
                    <textarea name="description" id="description" rows="4" class="form-control rounded-3" required>{{ old('description', $specialty->description) }}</textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Image</label>
                    @if($specialty->image)
                        <div class="mb-2">
                            <img src="{{ Storage::url($specialty->image) }}" alt="" class="rounded-3" style="max-height: 140px; object-fit: cover;">
                        </div>
                    @endif
                    <input type="file" name="image" accept="image/*" class="form-control rounded-3">
                    <div class="form-text">Leave empty to keep current image</div>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">Status</label>
                    <select name="is_active" class="form-select rounded-3">
                        <option value="1" {{ $specialty->is_active ? 'selected' : '' }}>Active</option>
                        <option value="0" {{ !$specialty->is_active ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>

                <div class="d-flex flex-column flex-sm-row justify-content-between gap-2">
                    <a href="{{ route('admin.specialties.index') }}" class="btn btn-outline-secondary rounded-pill">Cancel</a>
                    <button type="submit" class="btn btn-success rounded-pill px-4">Update Specialty</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.ckeditor.com/4.21.0/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('description');
</script>
@endsection
