@extends('admin.layouts.app')

@section('title', 'Specialties Management')
@section('page-title', 'Specialties Management')

@section('content')
<div class="container-fluid">

    <!-- Header -->
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0"><i class="fas fa-star text-success me-2"></i>Specialties</h2>
        <a href="{{ route('admin.specialties.create') }}" class="btn btn-success rounded-pill px-4">
            <i class="fas fa-plus me-2"></i>Add Specialty
        </a>
    </div>

    <!-- Card -->
    <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">

            @if($specialties->count())
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th scope="col" class="fw-semibold">#</th>
                                <th scope="col" class="fw-semibold">Title</th>
                                <th scope="col" class="fw-semibold">Status</th>
                                <th scope="col" class="fw-semibold">Image</th>
                                <th scope="col" class="fw-semibold">Created</th>
                                <th scope="col" class="fw-semibold text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($specialties as $s)
                            <tr>
                                <td>{{ $s->id }}</td>
                                <td class="text-truncate" style="max-width: 200px;">{{ $s->title }}</td>
                                <td>
                                    <span class="badge rounded-pill {{ $s->is_active ? 'bg-success' : 'bg-secondary' }}">
                                        {{ $s->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>
                                    @if($s->image)
                                        <img src="{{ $s->image_url }}" alt="" class="rounded-3" style="width: 48px; height: 48px; object-fit: cover;">
                                    @else
                                        <div class="bg-light rounded-3 d-inline-flex align-items-center justify-content-center" style="width: 48px; height: 48px;">
                                            <i class="fas fa-image text-muted"></i>
                                        </div>
                                    @endif
                                </td>
                                <td>{{ $s->created_at->format('M d, Y') }}</td>
                                <td class="text-center">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li><a class="dropdown-item" href="{{ route('admin.specialties.show', $s) }}"><i class="fas fa-eye text-primary me-2"></i>View</a></li>
                                            <li><a class="dropdown-item" href="{{ route('admin.specialties.edit', $s) }}"><i class="fas fa-edit text-warning me-2"></i>Edit</a></li>
                                            <li>
                                                <form action="{{ route('admin.specialties.destroy', $s) }}" method="POST" onsubmit="return confirm('Delete this specialty?')">
                                                    @csrf @method('DELETE')
                                                    <button type="submit" class="dropdown-item text-danger"><i class="fas fa-trash me-2"></i>Delete</button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                @if($specialties->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $specialties->links('pagination::bootstrap-4') }}
                    </div>
                @endif

            @else
                <div class="text-center py-5">
                    <i class="fas fa-star fa-3x text-success opacity-75 mb-3"></i>
                    <h5 class="fw-semibold text-dark mb-2">No specialties yet</h5>
                    <p class="text-muted mb-4">Add your first specialty to get started.</p>
                    <a href="{{ route('admin.specialties.create') }}" class="btn btn-success rounded-pill px-4">
                        <i class="fas fa-plus me-2"></i>Add Specialty
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection