@extends('admin.layouts.app')

@section('title', 'View Specialty')
@section('page-title', 'View Specialty')

@section('content')
<div class="container-fluid">
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0"><i class="fas fa-star text-success me-2"></i>{{ $specialty->title }}</h2>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.specialties.edit', $specialty) }}" class="btn btn-outline-success rounded-pill">
                <i class="fas fa-edit me-1"></i>Edit
            </a>
            <form action="{{ route('admin.specialties.destroy', $specialty) }}" method="POST"
                  onsubmit="return confirm('Delete this specialty?')" class="d-inline">
                @csrf @method('DELETE')
                <button type="submit" class="btn btn-outline-danger rounded-pill">
                    <i class="fas fa-trash me-1"></i>Delete
                </button>
            </form>
        </div>
    </div>

    <div class="row g-4">
        <!-- Details -->
        <div class="col-lg-8">
            <div class="card border-0 rounded-4 shadow-sm h-100">
                <div class="card-body p-4">
                    <div class="row mb-2">
                        <div class="col-sm-4 fw-semibold text-muted">Description</div>
                        <div class="col-sm-8">{!! nl2br(e($specialty->description)) !!}</div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-sm-4 fw-semibold text-muted">Status</div>
                        <div class="col-sm-8">
                            <span class="badge rounded-pill {{ $specialty->is_active ? 'bg-success' : 'bg-secondary' }}">
                                {{ $specialty->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 fw-semibold text-muted">Created</div>
                        <div class="col-sm-8">{{ $specialty->created_at->format('M d, Y h:i A') }}</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Image -->
        <div class="col-lg-4">
            <div class="card border-0 rounded-4 shadow-sm">
                <div class="card-body p-4 text-center">
                    @if($specialty->image)
                        <img src="{{ $specialty->image_url }}" alt="" class="img-fluid rounded-4 mb-3"
                             style="max-height: 220px; object-fit: cover;">
                        <a href="{{ $specialty->image_url }}" target="_blank" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-eye me-1"></i>View Full Size
                        </a>
                    @else
                        <div class="bg-light rounded-4 d-flex align-items-center justify-content-center" style="height: 220px;">
                            <i class="fas fa-image fa-3x text-muted"></i>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="text-center mt-4">
        <a href="{{ route('admin.specialties.index') }}" class="btn btn-outline-secondary rounded-pill px-4">
            <i class="fas fa-arrow-left me-2"></i>Back to List
        </a>
    </div>
</div>
@endsection