<!-- resources/views/admin/teachers/index.blade.php -->
@extends('admin.layouts.app')

@section('title', 'Manage Teachers')
@section('page-title', 'Teachers Management')

@section('content')
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center py-3 mb-4 border-bottom">
    <h1 class="h2"><i class="fas fa-chalkboard-teacher"></i> Teachers</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="{{ route('admin.teachers.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Teacher
        </a>
    </div>
</div>



@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Teachers</h5>
        <span class="badge bg-primary">{{ $teachers->total() }} Teachers</span>
    </div>
    <div class="card-body">
        @if($teachers->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Profile</th>
                            <th>Teacher Info</th>
                            <th>Contact</th>
                            <th>Experience</th>
                            <th>Courses</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($teachers as $teacher)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                @if($teacher->profile_image)
                                    <img src="{{ asset($teacher->profile_image) }}" 
                                         class="rounded-circle" width="50" height="50" 
                                         style="object-fit: cover;" alt="{{ $teacher->name }}">
                                @else
                                    <div class="bg-light rounded-circle d-flex align-items-center justify-content-center" 
                                         style="width: 50px; height: 50px;">
                                        <i class="fas fa-user text-muted"></i>
                                    </div>
                                @endif
                            </td>
                            <td>
                                <strong>{{ $teacher->name }}</strong>
                                @if($teacher->specialization)
                                    <br><small class="text-muted">{{ $teacher->specialization }}</small>
                                @endif
                                @if($teacher->is_featured)
                                    <br><span class="badge bg-warning mt-1">Featured</span>
                                @endif
                            </td>
                            <td>
                                <div><i class="fas fa-envelope text-muted me-2"></i>{{ $teacher->email }}</div>
                                @if($teacher->phone)
                                    <div><i class="fas fa-phone text-muted me-2"></i>{{ $teacher->phone }}</div>
                                @endif
                            </td>
                            <td>
                                @if($teacher->experience_years > 0)
                                    <span class="badge bg-info">{{ $teacher->experience_years }} years</span>
                                @else
                                    <span class="badge bg-secondary">No experience</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge bg-primary">{{ $teacher->courses_count ?? 0 }}</span>
                            </td>
                            <td>
                                @if($teacher->is_active)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-danger">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="{{ route('admin.teachers.show', $teacher) }}" 
                                       class="btn btn-sm btn-outline-info" data-bs-toggle="tooltip" title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.teachers.edit', $teacher) }}" 
                                       class="btn btn-sm btn-outline-primary" data-bs-toggle="tooltip" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('admin.teachers.destroy', $teacher) }}" 
                                          method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger" 
                                                onclick="return confirm('Are you sure you want to delete this teacher?')"
                                                data-bs-toggle="tooltip" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <div class="d-flex justify-content-center mt-4">
                {{ $teachers->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-chalkboard-teacher fa-4x text-muted mb-3"></i>
                <h5 class="text-muted">No teachers found</h5>
                <p class="text-muted">Get started by adding your first teacher.</p>
                <a href="{{ route('admin.teachers.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add First Teacher
                </a>
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    })
</script>
@endpush