<!-- resources/views/admin/teachers/show.blade.php -->
@extends('admin.layouts.app')

@section('title', $teacher->name)
@section('page-title', 'Teacher Details')

@section('content')
<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                @if($teacher->profile_image)
                    <img src="{{ asset($teacher->profile_image) }}" 
                         class="rounded-circle mb-3" width="150" height="150" 
                         style="object-fit: cover;" alt="{{ $teacher->name }}">
                @else
                    <div class="bg-light rounded-circle d-flex align-items-center justify-content-center mx-auto mb-3" 
                         style="width: 150px; height: 150px;">
                        <i class="fas fa-user fa-3x text-muted"></i>
                    </div>
                @endif
                
                <h4>{{ $teacher->name }}</h4>
                @if($teacher->specialization)
                    <p class="text-muted">{{ $teacher->specialization }}</p>
                @endif
                
                <div class="d-flex justify-content-center gap-2 mb-3">
                    @if($teacher->is_active)
                        <span class="badge bg-success">Active</span>
                    @else
                        <span class="badge bg-danger">Inactive</span>
                    @endif
                    
                    @if($teacher->is_featured)
                        <span class="badge bg-warning">Featured</span>
                    @endif
                </div>

                <!-- Social Links -->
                <div class="d-flex justify-content-center gap-3 mb-3">
                    @if($teacher->facebook_url)
                        <a href="{{ $teacher->facebook_url }}" target="_blank" class="text-primary">
                            <i class="fab fa-facebook fa-lg"></i>
                        </a>
                    @endif
                    @if($teacher->twitter_url)
                        <a href="{{ $teacher->twitter_url }}" target="_blank" class="text-info">
                            <i class="fab fa-twitter fa-lg"></i>
                        </a>
                    @endif
                    @if($teacher->linkedin_url)
                        <a href="{{ $teacher->linkedin_url }}" target="_blank" class="text-primary">
                            <i class="fab fa-linkedin fa-lg"></i>
                        </a>
                    @endif
                    @if($teacher->website_url)
                        <a href="{{ $teacher->website_url }}" target="_blank" class="text-success">
                            <i class="fas fa-globe fa-lg"></i>
                        </a>
                    @endif
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header bg-light">
                <h6 class="mb-0"><i class="fas fa-info-circle"></i> Contact Information</h6>
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <strong><i class="fas fa-envelope text-muted me-2"></i> Email:</strong><br>
                    <a href="mailto:{{ $teacher->email }}">{{ $teacher->email }}</a>
                </div>
                @if($teacher->phone)
                <div class="mb-2">
                    <strong><i class="fas fa-phone text-muted me-2"></i> Phone:</strong><br>
                    <a href="tel:{{ $teacher->phone }}">{{ $teacher->phone }}</a>
                </div>
                @endif
                @if($teacher->experience_years > 0)
                <div class="mb-2">
                    <strong><i class="fas fa-briefcase text-muted me-2"></i> Experience:</strong><br>
                    {{ $teacher->experience_years }} years
                </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Teacher Information</h5>
                <div class="btn-group">
                    <a href="{{ route('admin.teachers.edit', $teacher) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="{{ route('admin.teachers.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left"></i> Back
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <h6>Qualifications</h6>
                    <p class="text-muted">
                        {{ $teacher->qualifications ?: 'No qualifications provided.' }}
                    </p>
                </div>

                <div class="mb-4">
                    <h6>Biography</h6>
                    <p class="text-muted">
                        {{ $teacher->bio ?: 'No biography provided.' }}
                    </p>
                </div>

                <!-- Teacher's Courses -->
                <div class="mb-4">
                    <h6>Courses Taught ({{ $teacher->courses->count() }})</h6>
                    @if($teacher->courses->count() > 0)
                        <div class="list-group">
                            @foreach($teacher->courses as $course)
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1">{{ $course->title }}</h6>
                                        <small class="text-muted">
                                            {{ $course->category->name }} • 
                                            {{ $course->level }} • 
                                            {{ $course->duration_value }} {{ $course->duration_type }}
                                        </small>
                                    </div>
                                    <div class="text-end">
                                        @if($course->price_type === 'free')
                                            <span class="badge bg-success">Free</span>
                                        @else
                                            <span class="badge bg-primary">${{ number_format($course->price, 2) }}</span>
                                        @endif
                                        <br>
                                        <small class="text-muted">{{ $course->total_students }} students</small>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted">No courses assigned to this teacher yet.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection