@extends('admin.layouts.app')
@section('title', 'Add Testimonial')
@section('page-title', 'Add Testimonial')

@section('content')
<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus-circle text-success me-2"></i>Add Testimonial</h2>
    <a href="{{ route('admin.testimonials.index') }}" class="btn btn-outline-secondary rounded-pill">Back</a>
  </div>

  <div class="card border-0 rounded-4 shadow-sm">
    <div class="card-body p-4">
      <form action="{{ route('admin.testimonials.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label fw-semibold">Client Name <span class="text-danger">*</span></label>
            <input type="text" name="client_name" value="{{ old('client_name') }}" class="form-control rounded-3" required>
          </div>
          <div class="col-md-6">
            <label class="form-label fw-semibold">Profession <span class="text-danger">*</span></label>
            <input type="text" name="client_profession" value="{{ old('client_profession') }}" class="form-control rounded-3" required>
          </div>
        </div>

        <div class="mb-3 mt-3">
          <label class="form-label fw-semibold">Review <span class="text-danger">*</span></label>
          <textarea name="review" rows="4" class="form-control rounded-3" required>{{ old('review') }}</textarea>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">Stars <span class="text-danger">*</span></label>
          <select name="stars" class="form-select rounded-3">
            @for($i=1;$i<=5;$i++)
              <option value="{{ $i }}" {{ old('stars',5)==$i?'selected':'' }}>{{ $i }} Star{{ $i>1?'s':'' }}</option>
            @endfor
          </select>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">Image</label>
          <input type="file" name="image" accept="image/*" class="form-control rounded-3">
          <div class="form-text">JPEG, PNG, JPG, GIF ≤ 2 MB</div>
        </div>

        <div class="form-check mb-4">
          <input class="form-check-input" type="checkbox" name="is_active" value="1" checked>
          <label class="form-check-label fw-semibold">Active</label>
        </div>

        <div class="d-flex justify-content-end">
          <button type="submit" class="btn btn-success rounded-pill px-4">Save</button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection