@extends('apps')

@section('content')

<style>
:root {
    --primary: #28c57a;
    --primary-dark: #1fab69;
    --accent: #ff6b35;
    --dark: #1a1a1a;
    --light: #f8f9fa;
    --gray: #6c757d;
    --border: #dee2e6;
}

.article-hero {
    background: linear-gradient(135deg, var(--dark) 0%, #2d3748 100%);
    padding: 100px 0 60px;
    color: white;
    position: relative;
}

.article-title {
    font-size: 2.8rem;
    font-weight: 700;
    line-height: 1.3;
    margin-bottom: 1.5rem;
}

.author-section {
    display: flex;
    align-items: center;
    gap: 1.5rem;
    margin-bottom: 2rem;
    flex-wrap: wrap;
}

.author-avatar {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--primary));
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 1.3rem;
    border: 3px solid rgba(255,255,255,0.2);
}

.meta-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
    margin-bottom: 2rem;
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem;
    background: rgba(255,255,255,0.1);
    border-radius: 10px;
    backdrop-filter: blur(10px);
}

.meta-item i {
    color: var(--primary);
    font-size: 1.1rem;
}

.article-container {
    background: white;
    border-radius: 20px;
    margin-top: -40px;
    position: relative;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    overflow: hidden;
}

.featured-image {
    height: 450px;
    overflow: hidden;
}

.featured-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.article-content {
    padding: 3rem;
}

.article-body {
    font-size: 1.1rem;
    line-height: 1.8;
    color: #2d3748;
}

.article-body h2 {
    color: var(--dark);
    margin: 2.5rem 0 1.25rem;
    font-weight: 600;
    font-size: 1.8rem;
    border-bottom: 2px solid var(--primary);
    padding-bottom: 0.5rem;
}

.article-body h3 {
    color: var(--dark);
    margin: 2rem 0 1rem;
    font-weight: 600;
    font-size: 1.4rem;
}

.article-body blockquote {
    border-left: 4px solid var(--primary);
    padding: 1.5rem 2rem;
    margin: 2rem 0;
    background: var(--light);
    font-style: italic;
    color: var(--gray);
    border-radius: 0 10px 10px 0;
}

.article-actions {
    padding: 2rem 3rem;
    background: var(--light);
    border-top: 1px solid var(--border);
}

.tag-cloud {
    display: flex;
    flex-wrap: wrap;
    gap: 0.75rem;
    align-items: center;
}

.tag {
    background: white;
    color: var(--dark);
    padding: 0.6rem 1.2rem;
    border-radius: 25px;
    text-decoration: none;
    transition: all 0.3s ease;
    border: 2px solid var(--primary);
    font-weight: 500;
    font-size: 0.9rem;
}

.tag:hover {
    background: var(--primary);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(40, 197, 122, 0.3);
}

.social-share {
    display: flex;
    gap: 0.75rem;
}

.social-btn {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    text-decoration: none;
    transition: all 0.3s ease;
    border: 2px solid transparent;
    font-size: 1.1rem;
}

.social-btn:hover {
    transform: translateY(-3px);
    color: white;
    border-color: white;
}

.comments-section {
    padding: 4rem 0;
}

.comment-card {
    background: white;
    border-radius: 15px;
    padding: 2rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    border: 1px solid var(--border);
    transition: all 0.3s ease;
}

.comment-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 30px rgba(0,0,0,0.12);
}

.reply-card {
    margin-left: 3rem;
    background: #f8fff8;
    border-left: 4px solid var(--primary);
}

.comment-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1rem;
}

.comment-avatar {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--primary));
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 1.2rem;
    flex-shrink: 0;
}

.comment-meta h5 {
    margin-bottom: 0.25rem;
    color: var(--dark);
}

.comment-meta .date {
    color: var(--gray);
    font-size: 0.9rem;
}

.comment-body {
    margin-bottom: 1rem;
    line-height: 1.6;
    color: #4a5568;
}

.btn-reply {
    background: transparent;
    border: 2px solid var(--primary);
    color: var(--primary);
    padding: 0.5rem 1.5rem;
    border-radius: 25px;
    text-decoration: none;
    transition: all 0.3s ease;
    font-weight: 500;
    font-size: 0.9rem;
}

.btn-reply:hover {
    background: var(--primary);
    color: white;
    transform: translateY(-2px);
}

.reply-form-container {
    background: var(--light);
    border-radius: 10px;
    padding: 1.5rem;
    margin-top: 1rem;
    border: 1px solid var(--border);
}

.btn-primary-custom {
    background: linear-gradient(135deg, var(--primary), var(--primary-dark));
    color: white;
    padding: 0.75rem 2rem;
    border-radius: 25px;
    border: none;
    text-decoration: none;
    transition: all 0.3s ease;
    font-weight: 600;
}

.btn-primary-custom:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(40, 197, 122, 0.4);
    color: white;
}

.sidebar-widget {
    background: white;
    border-radius: 15px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    border: 1px solid var(--border);
}

.recent-post {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 0;
    border-bottom: 1px solid var(--border);
    text-decoration: none;
    color: var(--dark);
    transition: all 0.3s ease;
}

.recent-post:last-child {
    border-bottom: none;
}

.recent-post:hover {
    color: var(--primary);
    transform: translateX(8px);
}

.recent-post img {
    width: 80px;
    height: 80px;
    border-radius: 10px;
    object-fit: cover;
    flex-shrink: 0;
}

.recent-post-content h6 {
    margin-bottom: 0.5rem;
    line-height: 1.4;
}

.category-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem 0;
    border-bottom: 1px solid var(--border);
    text-decoration: none;
    color: var(--dark);
    transition: all 0.3s ease;
}

.category-item:last-child {
    border-bottom: none;
}

.category-item:hover {
    color: var(--primary);
    transform: translateX(8px);
}

.category-count {
    background: var(--primary);
    color: white;
    padding: 0.3rem 0.8rem;
    border-radius: 15px;
    font-size: 0.8rem;
    font-weight: 600;
}

.newsletter-widget {
    background: linear-gradient(135deg, var(--primary), var(--primary-dark));
    color: white;
    border-radius: 15px;
    padding: 2rem;
    text-align: center;
}

.newsletter-input {
    background: rgba(255,255,255,0.1);
    border: 1px solid rgba(255,255,255,0.3);
    color: white;
    border-radius: 25px;
    padding: 0.75rem 1.5rem;
    width: 100%;
    margin-bottom: 1rem;
    backdrop-filter: blur(10px);
}

.newsletter-input::placeholder {
    color: rgba(255,255,255,0.7);
}

.newsletter-btn {
    background: var(--accent);
    color: white;
    border: none;
    border-radius: 25px;
    padding: 0.75rem 2rem;
    width: 100%;
    font-weight: 600;
    transition: all 0.3s ease;
}

.newsletter-btn:hover {
    background: #e55a2b;
    transform: translateY(-2px);
}

/* Animations */
.fade-in {
    animation: fadeIn 0.6s ease-in-out;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Responsive */
@media (max-width: 768px) {
    .article-title {
        font-size: 2rem;
    }
    
    .featured-image {
        height: 300px;
    }
    
    .article-content {
        padding: 2rem 1.5rem;
    }
    
    .reply-card {
        margin-left: 1rem;
    }
    
    .author-section {
        justify-content: center;
        text-align: center;
    }
}

.blog-main-wrapper {
    display: flex;
    gap: 2rem;
    margin-top: 3rem;
}

.blog-content {
    flex: 1;
}

.blog-sidebar {
    width: 350px;
    flex-shrink: 0;
}

/* Responsive */
@media (max-width: 991px) {
    .blog-main-wrapper {
        flex-direction: column;
    }
    
    .blog-sidebar {
        width: 100%;
        order: 2;
    }
    
    .blog-content {
        order: 1;
    }
}
</style>

<!-- Hero Section -->
<section class="article-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto text-center">
                <h1 class="article-title text-white">{{ $post->title }}</h1>
                
                <div class="author-section justify-content-center">
                    <div class="author-avatar bg-primary">
                        {{ substr($post->author, 0, 1) }}
                    </div>
                    <div class="text-start">
                        <h4 class="mb-1 text-white">{{ $post->author }}</h4>
                        <p class="mb-0 opacity-75">Published Author</p>
                    </div>
                </div>
                
                <div class="meta-grid">
                    <div class="meta-item justify-content-center">
                        <i class="bi bi-calendar3"></i>
                        <div>
                            <strong>Published</strong>
                            <div>{{ $post->created_at->format('F d, Y') }}</div>
                        </div>
                    </div>
                    <div class="meta-item justify-content-center">
                        <i class="bi bi-chat-dots"></i>
                        <div>
                            <strong>Comments</strong>
                            <div>{{ $totalComments }}</div>
                        </div>
                    </div>
                    <div class="meta-item justify-content-center">
                        <i class="bi bi-tags"></i>
                        <div>
                            <strong>Category</strong>
                            <div>{{ $post->category->name }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Blog Content with Sidebar -->
<div class="container">
    <div class="blog-main-wrapper">
        <!-- Main Blog Content -->
        <div class="blog-content">
            <div class="article-container fade-in">
                <div class="featured-image">
                    <img src="{{ asset('blogs/'.$post->image) }}" alt="{{ $post->title }}">
                </div>
                
                <div class="article-content">
                    <div class="article-body">
                        {!! $post->content !!}
                    </div>
                </div>
                
                <div class="article-actions">
                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-4">
                        <div class="tag-cloud">
                            <strong class="me-2" style="color: var(--dark);">Tags:</strong>
                            @foreach(array_filter(explode(',', $post->tags), fn($tag) => trim($tag) !== '') as $tag)
                                <a href="{{ route('posts', trim($tag)) }}" class="tag">
                                    #{{ trim($tag) }}
                                </a>
                            @endforeach
                        </div>
                        
                        <div class="social-share">
                            <span class="m-2 fw-semibold" style="color: var(--dark);">Share:</span>
                            <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}&quote={{ urlencode($post->title) }}" 
                               class="social-btn" style="background: #1877F2;" target="_blank" title="Share on Facebook">
                                <i class="bi bi-facebook"></i>
                            </a>
                            <a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($post->title) }}" 
                               class="social-btn" style="background: #1DA1F2;" target="_blank" title="Share on Twitter">
                                <i class="bi bi-twitter"></i>
                            </a>
                            <a href="https://www.linkedin.com/sharing/share-offsite/?url={{ urlencode(url()->current()) }}" 
                               class="social-btn" style="background: #0A66C2;" target="_blank" title="Share on LinkedIn">
                                <i class="bi bi-linkedin"></i>
                            </a>
                            <a href="https://wa.me/?text={{ urlencode($post->title . ' - ' . url()->current()) }}" 
                               class="social-btn" style="background: #25D366;" target="_blank" title="Share on WhatsApp">
                                <i class="bi bi-whatsapp"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Comments Section (Now below blog content) -->
            <section class="comments-section">
                <div class="container">
                    <div class="d-flex align-items-center mb-4">
                        <h3 class="mb-0 me-3">Comments</h3>
                        <span class="badge bg-primary fs-6">{{ $post->comments()->whereNull('parent_id')->count() }}</span>
                    </div>
                    
                    <div id="comments-wrapper">
                        @foreach($post->comments()->whereNull('parent_id')->latest()->get() as $comment)
                            <div class="comment-card fade-in">
                                <div class="comment-header">
                                    <div class="comment-avatar">
                                        {{ substr($comment->name, 0, 1) }}
                                    </div>
                                    <div class="comment-meta">
                                        <h5 class="mb-0">{{ $comment->name }}</h5>
                                        <div class="date">{{ $comment->created_at->format('F j, Y \\a\\t g:i A') }}</div>
                                    </div>
                                </div>
                                
                                <div class="comment-body">
                                    {{ $comment->comment }}
                                </div>
                                
                                <button class="btn-reply reply-btn" data-id="{{ $comment->id }}">
                                    <i class="bi bi-reply me-1"></i>Reply
                                </button>

                                <!-- Reply Form -->
                                <form method="POST" action="{{ route('comment', $post->id) }}"
                                      class="reply-form-container mt-3" id="reply-form-{{ $comment->id }}" style="display:none;">
                                    @csrf
                                    <input type="hidden" name="parent_id" value="{{ $comment->id }}">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <input type="text" name="name" class="form-control" placeholder="Your Name" required>
                                        </div>
                                        <div class="col-md-6">
                                            <input type="email" name="email" class="form-control" placeholder="Your Email" required>
                                        </div>
                                        <div class="col-12">
                                            <textarea name="comment" class="form-control" rows="3" placeholder="Write your reply..." required></textarea>
                                        </div>
                                        <div class="col-12">
                                            <button type="submit" class="btn-primary-custom">Post Reply</button>
                                        </div>
                                    </div>
                                </form>

                                <!-- Replies -->
                                @if($comment->replies->count())
                                    <button class="btn btn-link text-primary p-0 mt-3 toggle-replies" data-id="{{ $comment->id }}">
                                        <i class="bi bi-chevron-down me-1"></i>
                                        View {{ $comment->replies->count() }} Replies
                                    </button>
                                    <div class="replies mt-3" id="replies-{{ $comment->id }}" style="display:none;">
                                        @foreach($comment->replies as $reply)
                                            <div class="comment-card reply-card mt-3 fade-in">
                                                <div class="comment-header">
                                                    <div class="comment-avatar" style="width: 40px; height: 40px; font-size: 1rem;">
                                                        {{ substr($reply->name, 0, 1) }}
                                                    </div>
                                                    <div class="comment-meta">
                                                        <h6 class="mb-0">{{ $reply->name }}</h6>
                                                        <div class="date" style="font-size: 0.8rem;">{{ $reply->created_at->format('M j, Y \\a\\t g:i A') }}</div>
                                                    </div>
                                                </div>
                                                <div class="comment-body">
                                                    {{ $reply->comment }}
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        @endforeach
                    </div>

                    <!-- Comment Form -->
                    <div class="comment-card mt-4">
                        <h4 class="mb-3">Leave a Comment</h4>
                        <form id="comment-form" method="POST" action="{{ route('comment', $post->id) }}">
                            @csrf
                            <input type="hidden" name="post_id" value="{{ $post->id }}">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <input type="text" name="name" class="form-control" placeholder="Your Name" required>
                                </div>
                                <div class="col-md-6">
                                    <input type="email" name="email" class="form-control" placeholder="Your Email" required>
                                </div>
                                <div class="col-12">
                                    <textarea name="comment" rows="5" class="form-control" placeholder="Share your thoughts..." required></textarea>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn-primary-custom">
                                        <i class="bi bi-send me-2"></i>Post Comment
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>

        <!-- Sidebar - Right Side of Blog Content -->
        <div class="blog-sidebar">
            <!-- Recent Posts -->
            <div class="sidebar-widget">
                <h4 class="mb-3">Recent Articles</h4>
                @foreach($recentPosts as $recentPost)
                    <a href="{{ route('details', $recentPost->slug) }}" class="recent-post">
                        <img src="{{ asset('blogs/'.$recentPost->image) }}" alt="{{ $recentPost->title }}">
                        <div class="recent-post-content">
                            <h6>{{ Str::limit($recentPost->title, 50) }}</h6>
                            <small class="text-muted">{{ $recentPost->created_at->format('M d, Y') }}</small>
                        </div>
                    </a>
                @endforeach
            </div>

            <!-- Categories -->
            <div class="sidebar-widget">
                <h4 class="mb-3">Categories</h4>
                @foreach($blogCategories as $category)
                    <a href="{{ route('category.posts', ['id' => $category->id]) }}" class="category-item">
                        <span><i class="fas fa-tags"></i> {{ $category->name }}</span>
                        <span class="category-count">{{ $category->posts->count() }}</span>
                    </a>
                @endforeach
            </div>
        </div>
    </div>
</div>

<!-- SweetAlert -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<script>
// Simple form submission with SweetAlert
document.addEventListener('submit', function(e) {
    if (e.target.matches('form')) {
        // Show loading state
        const submitBtn = e.target.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="bi bi-arrow-repeat spinner"></i> Posting...';
        submitBtn.disabled = true;
        
        // Form will submit normally, page will reload
        // SweetAlert will show after page reload based on session
    }
});

// Toggle functionality
document.addEventListener('click', function(e) {
    // Reply buttons
    if (e.target.classList.contains('reply-btn')) {
        const id = e.target.dataset.id;
        const form = document.getElementById(`reply-form-${id}`);
        form.style.display = form.style.display === 'none' ? 'block' : 'none';
    }
    
    // Toggle replies
    if (e.target.classList.contains('toggle-replies')) {
        const id = e.target.dataset.id;
        const box = document.getElementById(`replies-${id}`);
        const show = box.style.display === 'none';
        box.style.display = show ? 'block' : 'none';
        e.target.innerHTML = show ? 
            '<i class="bi bi-chevron-up me-1"></i>Hide Replies' : 
            '<i class="bi bi-chevron-down me-1"></i>View ' + box.children.length + ' Replies';
    }
});

// Show SweetAlert from session (if any)
@if(session('success'))
Swal.fire({
    icon: 'success',
    title: '{{ session('success') }}',
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true
});
@endif

@if(session('error'))
Swal.fire({
    icon: 'error',
    title: '{{ session('error') }}',
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true
});
@endif
</script>

@endsection
