@extends('apps')

@section('content')
 <style >.blog-posts .meta .post-date {
    background: #28c57a!important;
}
i{
    color:#28c57a!important;
}
.blog-posts article:hover .post-title,
.blog-posts article:hover .readmore {
  color: #28c57a!important;
}


</style>
<main class="main">

    <!-- Page Title -->
    <div class="page-title light-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0">Blog</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="{{ url('/') }}">Home</a></li>
                    <li class="current">Blog</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Blog Hero Section -->
    <section id="blog-hero" class="blog-hero section">
        <div class="container" data-aos="fade-up" data-aos-delay="100">
            
            @if($blog->count() > 0)
            <div class="blog-grid">
                
                <!-- Featured Post (Large) - First Post -->
                <article class="blog-item featured" data-aos="fade-up">
                    <img src="{{ asset('blogs/'.$blog[0]->image) }}" alt="{{ $blog[0]->title }}" class="img-fluid">
                    <div class="blog-content">
                        <div class="post-meta">
                            <span class="date">{{ $blog[0]->created_at->format('M d, Y') }}</span>
                            <span class="category">{{ $blog[0]->category->name }}</span>
                        </div>
                        <h2 class="post-title">
                            <a href="{{ route('details', $blog[0]->slug) }}" title="{{ $blog[0]->title }}">
                                {{ $blog[0]->title }}
                            </a>
                        </h2>
                    </div>
                </article><!-- End Featured Post -->

                <!-- Regular Posts - Next 4 Posts -->
                @foreach($blog->skip(1)->take(4) as $post)
                <article class="blog-item" data-aos="fade-up" data-aos-delay="{{ ($loop->index + 1) * 100 }}">
                    <img src="{{ asset('blogs/'.$post->image) }}" alt="{{ $post->title }}" class="img-fluid">
                    <div class="blog-content">
                        <div class="post-meta">
                            <span class="date">{{ $post->created_at->format('M d, Y') }}</span>
                            <span class="category">{{ $post->category->name }}</span>
                        </div>
                        <h3 class="post-title">
                            <a href="{{ route('details', $post->slug) }}" title="{{ $post->title }}">
                                {{ Str::limit($post->title, 60) }}
                            </a>
                        </h3>
                    </div>
                </article><!-- End Blog Item -->
                @endforeach

            </div>
            @else
            <div class="text-center py-5">
                <h3>No blog posts found</h3>
                <p>Check back later for new content.</p>
            </div>
            @endif

        </div>
    </section><!-- /Blog Hero Section -->

    <!-- Blog Posts Section -->
    <section id="blog-posts" class="blog-posts section">
        <div class="container" data-aos="fade-up" data-aos-delay="100">
            
            @if($blog->count() > 5)
            <div class="row gy-4">
                
                @foreach($blog->skip(5) as $post)
                <div class="col-lg-4">
                    <article class="position-relative h-100">

                        <div class="post-img position-relative overflow-hidden">
                            <img src="{{ asset('blogs/'.$post->image) }}" class="img-fluid" alt="{{ $post->title }}">
                        </div>

                        <div class="meta d-flex align-items-end">
                            <span class="post-date">
                                <span>{{ $post->created_at->format('d') }}</span>
                                {{ $post->created_at->format('F') }}
                            </span>
                            <div class="d-flex align-items-center">
                                <i class="bi bi-person"></i> 
                                <span class="ps-2">{{ $post->author }}</span>
                            </div>
                            <span class="px-3 text-black-50">/</span>
                            <div class="d-flex align-items-center">
                                <i class="bi bi-folder2"></i> 
                                <span class="ps-2">{{ $post->category->name }}</span>
                            </div>
                        </div>

                        <div class="post-content d-flex flex-column">
                            <h3 class="post-title">{{ Str::limit($post->title, 70) }}</h3>
                            <a href="{{ route('details', $post->slug) }}" class="readmore stretched-link">
                                <span>Read More</span>
                                <i class="bi bi-arrow-right"></i>
                            </a>
                        </div>

                    </article>
                </div><!-- End post list item -->
                @endforeach

            </div>
            @endif

        </div>
    </section><!-- /Blog Posts Section -->

    <!-- Pagination Section -->
  <div class="col-12 mt-4 d-flex justify-content-center">
    {{ $blog->links('pagination::bootstrap-5') }}
</div>
    

</main>
@endsection
