@extends('apps')

@section('content')
{{-- Breadcrumb --}}
<style >
    .breadcrumb{
        background: inherit!important;
    }
</style>
<div class="bg-dark py-4 mb-4">
    <div class="container text-white">
        <h4 class="mb-1 text-white">{{ $category->name }} Posts</h4>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="{{ url('/') }}" class="text-white text-decoration-none">Home</a></li> &nbsp; >
                <li class="breadcrumb-item active text-white" aria-current="page">{{ $category->name }}</li>
            </ol>
        </nav>
    </div>
</div>

{{-- Main Section --}}
<div class="container pb-5">
    @if($posts->count())
        <div class="row g-4">
            @foreach($posts as $post)
                <div class="col-md-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <img src="{{ asset('blogs/' . $post->image) }}" class="card-img-top" alt="{{ $post->title }}">
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title fw-bold">{{ $post->title }}</h5>
                            <p class="card-text small text-muted">{{ $post->short_description }}</p>
                            <div class="mt-auto d-flex justify-content-between align-items-center small text-muted">
                                <span>
                                    <i class="fas fa-calendar-alt me-1"></i>
                                    Posted on {{ $post->created_at->format('M d, Y') }}
                                </span>
                                <a href="{{ route('details', $post->slug) }}" class="btn btn-sm" style="background-color: #1dbf73; color: #fff;">Read More</a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

<div class="mt-4 py-2 px-3 rounded border d-flex flex-column flex-md-row justify-content-between align-items-center bg-light">
    <div class="small text-muted mb-2 mb-md-0">
        Showing {{ $posts->firstItem() }} to {{ $posts->lastItem() }} of {{ $posts->total() }} results
    </div>
    <nav>
        {{ $posts->onEachSide(1)->links('pagination::bootstrap-5') }}
    </nav>
</div>



    @else
        <div class="alert alert-warning mt-4">No posts found for this category.</div>
    @endif
</div>

@endsection
