@extends('apps')

@section('content')
<main class="main">

    <!-- Page Title -->
    <div class="page-title light-background">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">Courses</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="{{ url('/') }}">Home</a></li>
            <li class="current">Courses</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- Courses 2 Section -->
    <section id="courses-2" class="courses-2 section">

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row">
          <div class="col-lg-3">
            <div class="course-filters" data-aos="fade-right" data-aos-delay="100">
              <h4 class="filter-title">Filter Courses</h4>

              <form id="filterForm" method="GET" action="{{ route('courses-quran') }}">
                <div class="filter-group">
                  <h5>Category</h5>
                  <div class="filter-options">
                    <label class="filter-checkbox">
                      <input type="radio" name="category" value="" {{ !request('category') ? 'checked' : '' }} onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      All Categories
                    </label>
                    @foreach($categories as $category)
                    <label class="filter-checkbox">
                      <input type="radio" name="category" value="{{ $category->id }}" {{ request('category') == $category->id ? 'checked' : '' }} onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      {{ $category->name }}
                    </label>
                    @endforeach
                  </div>
                </div>

                <div class="filter-group">
                  <h5>Level</h5>
                  <div class="filter-options">
                    <label class="filter-checkbox">
                      <input type="radio" name="level" value="" {{ !request('level') ? 'checked' : '' }} onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      All Levels
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="level" value="beginner" {{ request('level') == 'beginner' ? 'checked' : '' }} onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Beginner
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="level" value="intermediate" {{ request('level') == 'intermediate' ? 'checked' : '' }} onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Intermediate
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="level" value="advanced" {{ request('level') == 'advanced' ? 'checked' : '' }} onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Advanced
                    </label>
                  </div>
                </div>
<div class="filter-group">
  <h5>Duration</h5>
  <div class="filter-options">
    <label class="filter-checkbox">
      <input type="radio" name="duration" value="" {{ !request('duration') ? 'checked' : '' }} onchange="this.form.submit()">
      <span class="checkmark"></span>
      All Durations
    </label>

    <label class="filter-checkbox">
      <input type="radio" name="duration" value="hours" {{ request('duration') == 'hours' ? 'checked' : '' }} onchange="this.form.submit()">
      <span class="checkmark"></span>
      Hours
    </label>

    <label class="filter-checkbox">
      <input type="radio" name="duration" value="days" {{ request('duration') == 'days' ? 'checked' : '' }} onchange="this.form.submit()">
      <span class="checkmark"></span>
      Days
    </label>

    <label class="filter-checkbox">
      <input type="radio" name="duration" value="weeks" {{ request('duration') == 'weeks' ? 'checked' : '' }} onchange="this.form.submit()">
      <span class="checkmark"></span>
      Weeks
    </label>

    <label class="filter-checkbox">
      <input type="radio" name="duration" value="months" {{ request('duration') == 'months' ? 'checked' : '' }} onchange="this.form.submit()">
      <span class="checkmark"></span>
      Months
    </label>
  </div>
</div>



                <div class="filter-group">
                  <h5>Price</h5>
                  <div class="filter-options">
                    <label class="filter-checkbox">
                      <input type="radio" name="price_type" value="" {{ !request('price_type') ? 'checked' : '' }} onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      All Prices
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="price_type" value="free" {{ request('price_type') == 'free' ? 'checked' : '' }} onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Free
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="price_type" value="paid" {{ request('price_type') == 'paid' ? 'checked' : '' }} onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Paid
                    </label>
                  </div>
                </div>

                <!-- Hidden fields to preserve other filters -->
                <input type="hidden" name="search" value="{{ request('search') }}">
                <input type="hidden" name="sort" value="{{ request('sort') }}">
              </form>
            </div><!-- End Course Filters -->
          </div>

          <div class="col-lg-9">
            <div class="courses-header" data-aos="fade-left" data-aos-delay="100">
              <form method="GET" action="{{ route('courses-quran') }}" class="d-flex align-items-center gap-3">
                <div class="search-box">
                  <i class="bi bi-search"></i>
                  <input type="text" name="search" placeholder="Search courses..." value="{{ request('search') }}">
                </div>
                <div class="sort-dropdown">
            <select name="sort" onchange="this.form.submit()">
  <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>Sort by: Newest First</option>
  <option value="popular" {{ request('sort') == 'popular' ? 'selected' : '' }}>Most Popular</option>
  <option value="price_low" {{ request('sort') == 'price_low' ? 'selected' : '' }}>Price: Low to High</option>
  <option value="price_high" {{ request('sort') == 'price_high' ? 'selected' : '' }}>Price: High to Low</option>
  <option value="duration" {{ request('sort') == 'duration' ? 'selected' : '' }}>Duration: Short to Long</option>
</select>

                </div>
                
                <!-- Hidden fields to preserve filters -->
                <input type="hidden" name="category" value="{{ request('category') }}">
                <input type="hidden" name="level" value="{{ request('level') }}">
                <input type="hidden" name="duration" value="{{ request('duration') }}">
                <input type="hidden" name="price_type" value="{{ request('price_type') }}">
              </form>
            </div>

 <div class="courses-grid" data-aos="fade-up" data-aos-delay="200">
              <div class="row">
                @foreach($courses as $course)

                <div class="col-lg-6 col-md-6 mb-4">
                  <a href="{{ route('nadeem', $course->slug) }}">
                  <div class="course-card">
                    <div class="course-image">
                      @if($course->image)
                        <img src="{{ asset($course->image) }}" alt="{{ $course->title }}" class="img-fluid">
                      @else
                        <img src="{{ asset('assets/img/education/courses-3.webp') }}" alt="{{ $course->title }}" class="img-fluid">
                      @endif
                      
                      <!-- Course Badges -->
                      @if($course->label)
                        <div class="course-badge badge-{{ $course->label }}">
                         <i class="fas fa-crown "></i> {{ ucfirst($course->label) }}
                        </div>
                      @endif
                      
                  
                      <!-- Price -->
                      <div class="course-price">
                        @if($course->price_type === 'free')
                          <i class="fas fa-gift"></i> Free
                        @else
                          ${{ number_format($course->price, 2) }}
                        @endif
                      </div>
                    </div>
                    
                    <div class="course-content">
                      <div class="course-meta">
                        <span class="category text-dark"><i class="fas fa-tags"></i> {{ $course->category->name }}</span>
                        <span class="level level-{{ $course->level }}"><i class="fas fa-layer-group"></i> {{ ucfirst($course->level) }}</span>
                            @if($course->has_certificate)
                        <span class="category text-dark"><i class="fas fa-award"></i> Certificate</span>
                      @endif

                      </div>
                      <h3>{{ $course->title }}</h3>
                      <p>{{ Str::limit($course->description, 120) }}</p>
                      
                      <div class="course-stats">
                        <div class="stat">
                          <i class="bi bi-clock"></i>
                          <span>{{ $course->duration_value }} {{ $course->duration_type }}</span>
                        </div>
                        <div class="stat">
                          <i class="bi bi-people"></i>
                          <span>{{ $course->total_students }} students</span>
                        </div>
                        <div class="rating">
                          @php
                            $fullStars = floor($course->ratings);
                            $halfStar = ($course->ratings - $fullStars) >= 0.5;
                            $emptyStars = 5 - $fullStars - ($halfStar ? 1 : 0);
                          @endphp
                          
                          @for($i = 0; $i < $fullStars; $i++)
                            <i class="bi bi-star-fill"></i>
                          @endfor
                          
                          @if($halfStar)
                            <i class="bi bi-star-half"></i>
                          @endif
                          
                          @for($i = 0; $i < $emptyStars; $i++)
                            <i class="bi bi-star"></i>
                          @endfor
                          
                          <span>{{ number_format($course->ratings, 1) }} ({{ $course->total_students }} reviews)</span>
                        </div>
                      </div>
                      
                      <div class="instructor-info">
                        @if($course->teacher->profile_image)
                          <img src="{{ asset($course->teacher->profile_image) }}" alt="{{ $course->teacher->name }}" class="instructor-avatar">
                        @else
                          <img src="{{ asset('assets/img/person/person-m-3.webp') }}" alt="{{ $course->teacher->name }}" class="instructor-avatar">
                        @endif
                        <span class="instructor-name">{{ $course->teacher->name }}</span>
                      </div>
                      
                   


<a href="{{ route('enrollment.form', $course->slug) }}" class="">
    @if($course->price_type === 'free')
    <button class="btn btn-primary w-100"> <i class="fas fa-gift"></i> Start Free Course</button>
    @else
       <button class="btn btn-success w-100"><i class="fas fa-rocket"></i> Enroll Now</button>
    @endif
</a>

                    </div>
                  </div><!-- End Course Card -->
                                     </a>

                </div>
                @endforeach

                @if($courses->count() == 0)
                <div class="col-12 text-center py-5">
                  <h4>No courses found</h4>
                  <p class="text-muted">Try adjusting your search or filters</p>
                </div>
                @endif
              </div>
            </div><!-- End Courses Grid -->
       

            <!-- Pagination -->
            @if($courses->hasPages())
            <div class="pagination-wrapper" data-aos="fade-up" data-aos-delay="300">
              <nav aria-label="Courses pagination">
                <ul class="pagination justify-content-center">
                  {{ $courses->appends(request()->query())->links() }}
                </ul>
              </nav>
            </div><!-- End Pagination -->
            @endif

          </div>
        </div>

      </div>

    </section><!-- /Courses 2 Section -->

  </main>

  @include('footer')

  <style>
    .search-box {
      position: relative;
      flex: 1;
    }
    
    .search-box i {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #6c757d;
    }
    
    .search-box input {
      padding-left: 45px;
      width: 100%;
      border: 1px solid #dee2e6;
      border-radius: 8px;
      height: 45px;
    }
    
    .sort-dropdown select {
      border: 1px solid #dee2e6;
      border-radius: 8px;
      height: 45px;
      padding: 0 15px;
    }
    
    .courses-header {
      display: flex;
      gap: 20px;
      margin-bottom: 30px;
      align-items: center;
    }
    
    .filter-checkbox {
      display: block;
      margin-bottom: 10px;
      cursor: pointer;
    }
    
    .course-badge {
      position: absolute;
      top: 15px;
      left: 15px;
      background: #28a745;
      color: white;
      padding: 5px 10px;
      border-radius: 4px;
      font-size: 0.8rem;
      font-weight: 500;
    }
    
    .badge-new { background: #dc3545; }
    .badge-popular { background: #ffc107; color: #000; }
    .badge-featured { background: #17a2b8; }
    .badge-free { background: #28a745; }
    .badge-certificate { background: #6f42c1; }
    
    .course-price {
      position: absolute;
      top: 15px;
      right: 15px;
      background: rgba(0,0,0,0.8);
      color: white;
      padding: 5px 10px;
      border-radius: 4px;
      font-weight: 600;
    }
    
    .level-beginner { background: #28a745; color: white; }
    .level-intermediate { background: #ffc107; color: #000; }
    .level-advanced { background: #dc3545; color: white; }
  </style>

  <script>
    // Auto submit search on enter
    document.querySelector('input[name="search"]').addEventListener('keypress', function(e) {
      if (e.key === 'Enter') {
        this.form.submit();
      }
    });
    
    // Clear filters
    function clearFilters() {
      window.location.href = "{{ route('courses-quran') }}";
    }
  </script>

@endsection
