<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $course->meta_title ?? $course->title }}</title>
    <meta name="description" content="{{ $course->meta_description ?? Str::limit($course->description, 160) }}">
    <meta name="keywords" content="{{ $course->meta_keywords }}">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .course-hero {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 80px 0 50px;
        }
        .course-image {
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }
        .course-badge {
            position: absolute;
            top: 15px;
            left: 15px;
            z-index: 2;
        }
        .instructor-card {
            background: #f8f9fa;
            border-radius: 15px;
            padding: 25px;
        }
        .curriculum-item {
            border-left: 3px solid #667eea;
            padding-left: 20px;
            margin-bottom: 15px;
        }
        .enroll-btn {
            background: linear-gradient(135deg, #28a745, #20c997);
            border: none;
            padding: 15px 30px;
            font-size: 18px;
            border-radius: 50px;
            transition: all 0.3s ease;
        }
        .enroll-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(40, 167, 69, 0.3);
        }
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body>

<!-- Course Hero Section -->
<section class="course-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="/" class="text-white">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('courses') }}" class="text-white">Courses</a></li>
                        <li class="breadcrumb-item"><a href="#" class="text-white">{{ $course->category->name }}</a></li>
                        <li class="breadcrumb-item active text-white" aria-current="page">{{ $course->title }}</li>
                    </ol>
                </nav>
                
                <h1 class="display-4 fw-bold mb-3">{{ $course->title }}</h1>
                <p class="lead mb-4">{{ $course->description }}</p>
                
                <div class="d-flex flex-wrap gap-3 mb-4">
                    <span class="badge bg-warning fs-6 p-2">
                        <i class="fas fa-layer-group me-1"></i>
                        {{ ucfirst($course->level) }} Level
                    </span>
                    @if($course->has_certificate)
                    <span class="badge bg-success fs-6 p-2">
                        <i class="fas fa-award me-1"></i>
                        Certificate
                    </span>
                    @endif
                    <span class="badge bg-info fs-6 p-2">
                        <i class="fas fa-clock me-1"></i>
                        {{ $course->duration_value }} {{ $course->duration_type }}
                    </span>
                </div>

                <div class="d-flex align-items-center gap-4 text-white">
                    <div class="rating">
                        @php
                            $fullStars = floor($course->ratings);
                            $halfStar = ($course->ratings - $fullStars) >= 0.5;
                            $emptyStars = 5 - $fullStars - ($halfStar ? 1 : 0);
                        @endphp
                        
                        @for($i = 0; $i < $fullStars; $i++)
                            <i class="fas fa-star text-warning"></i>
                        @endfor
                        
                        @if($halfStar)
                            <i class="fas fa-star-half-alt text-warning"></i>
                        @endif
                        
                        @for($i = 0; $i < $emptyStars; $i++)
                            <i class="far fa-star text-warning"></i>
                        @endfor
                        
                        <span class="ms-2 fs-5">{{ number_format($course->ratings, 1) }} ({{ $course->total_students }} reviews)</span>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="position-relative">
                    @if($course->image)
                        <img src="{{ asset($course->image) }}" alt="{{ $course->title }}" class="img-fluid course-image">
                    @else
                        <img src="{{ asset('assets/img/education/courses-3.webp') }}" alt="{{ $course->title }}" class="img-fluid course-image">
                    @endif
                    
                    @if($course->label)
                        <div class="course-badge">
                            <span class="badge bg-danger fs-6 p-2">
                                <i class="fas fa-crown me-1"></i>
                                {{ ucfirst($course->label) }}
                            </span>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Course Details Section -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8">
                <!-- What You'll Learn -->
                @if($course->what_you_learn)
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-transparent border-0">
                        <h3 class="card-title mb-0">
                            <i class="fas fa-bullseye text-primary me-2"></i>
                            What You'll Learn
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @php
                                $learnPoints = explode("\n", $course->what_you_learn);
                            @endphp
                            @foreach(array_chunk($learnPoints, ceil(count($learnPoints)/2)) as $chunk)
                                <div class="col-md-6">
                                    <ul class="list-unstyled">
                                        @foreach($chunk as $point)
                                            @if(trim($point))
                                                <li class="mb-2">
                                                    <i class="fas fa-check-circle text-success me-2"></i>
                                                    {{ trim($point) }}
                                                </li>
                                            @endif
                                        @endforeach
                                    </ul>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endif

                <!-- Requirements -->
                @if($course->requirements)
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-transparent border-0">
                        <h3 class="card-title mb-0">
                            <i class="fas fa-tools text-warning me-2"></i>
                            Requirements
                        </h3>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled">
                            @php
                                $requirements = explode("\n", $course->requirements);
                            @endphp
                            @foreach($requirements as $requirement)
                                @if(trim($requirement))
                                    <li class="mb-2">
                                        <i class="fas fa-circle text-info me-2 small"></i>
                                        {{ trim($requirement) }}
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                    </div>
                </div>
                @endif

                <!-- Course Curriculum (Sample) -->
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-transparent border-0">
                        <h3 class="card-title mb-0">
                            <i class="fas fa-list-ol text-success me-2"></i>
                            Course Curriculum
                        </h3>
                    </div>
                    <div class="card-body">
                        @for($i = 1; $i <= 5; $i++)
                            <div class="curriculum-item mb-3">
                                <h5 class="mb-1">Chapter {{ $i }}: Introduction to Topic {{ $i }}</h5>
                                <p class="text-muted mb-2">Learn the fundamentals of this important concept</p>
                                <small class="text-muted">
                                    <i class="fas fa-play-circle me-1"></i> 5 lessons • 
                                    <i class="fas fa-clock me-1"></i> 45 mins
                                </small>
                            </div>
                        @endfor
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Enrollment Card -->
                <div class="card border-0 shadow-lg sticky-top" style="top: 100px;">
                    <div class="card-body text-center p-4">
                        <div class="price-section mb-4">
                            @if($course->price_type === 'free')
                                <h2 class="text-success display-4 fw-bold">FREE</h2>
                                <p class="text-muted">Lifetime access</p>
                            @else
                                <h2 class="text-primary display-4 fw-bold">${{ number_format($course->price, 2) }}</h2>
                                <p class="text-muted">One-time payment</p>
                            @endif
                        </div>

                        <a href="{{ route('enrollment.form', $course->slug) }}" class="btn enroll-btn btn-lg w-100 mb-3">
                            @if($course->price_type === 'free')
                                <i class="fas fa-gift me-2"></i>Enroll For Free
                            @else
                                <i class="fas fa-rocket me-2"></i>Enroll Now
                            @endif
                        </a>

                        <div class="guarantee-badge mb-4">
                            <small class="text-muted">
                                <i class="fas fa-shield-alt me-1"></i>
                                30-day money-back guarantee
                            </small>
                        </div>

                        <!-- Course Stats -->
                        <div class="row g-3 mb-4">
                            <div class="col-6">
                                <div class="stat-card">
                                    <i class="fas fa-play-circle text-primary fs-4 mb-2"></i>
                                    <h5 class="mb-1">25+</h5>
                                    <small class="text-muted">Lessons</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="stat-card">
                                    <i class="fas fa-clock text-warning fs-4 mb-2"></i>
                                    <h5 class="mb-1">{{ $course->duration }}</h5>
                                    <small class="text-muted">Duration</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="stat-card">
                                    <i class="fas fa-users text-info fs-4 mb-2"></i>
                                    <h5 class="mb-1">{{ $course->total_students }}+</h5>
                                    <small class="text-muted">Students</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="stat-card">
                                    <i class="fas fa-chart-line text-success fs-4 mb-2"></i>
                                    <h5 class="mb-1">{{ $course->level }}</h5>
                                    <small class="text-muted">Level</small>
                                </div>
                            </div>
                        </div>

                        <!-- Instructor Info -->
                        <div class="instructor-card text-start">
                            <h5 class="mb-3">About Instructor</h5>
                            <div class="d-flex align-items-center mb-3">
                                @if($course->teacher->profile_image)
                                    <img src="{{ asset($course->teacher->profile_image) }}" 
                                         alt="{{ $course->teacher->name }}" 
                                         class="rounded-circle me-3" width="60" height="60">
                                @else
                                    <img src="{{ asset('assets/img/person/person-m-3.webp') }}" 
                                         alt="{{ $course->teacher->name }}" 
                                         class="rounded-circle me-3" width="60" height="60">
                                @endif
                                <div>
                                    <h6 class="mb-1">{{ $course->teacher->name }}</h6>
                                    <small class="text-muted">Professional Instructor</small>
                                </div>
                            </div>
                            <p class="small text-muted mb-0">
                                Experienced educator with passion for teaching and student success.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>